/*
 * Decompiled with CFR 0.152.
 */
package net.adeptropolis.frogspawn.graphs.operators;

import com.google.common.annotations.VisibleForTesting;
import net.adeptropolis.frogspawn.graphs.Graph;
import net.adeptropolis.frogspawn.graphs.operators.CanonicalLinearOperator;
import net.adeptropolis.frogspawn.graphs.operators.LinearGraphOperator;
import net.adeptropolis.frogspawn.helpers.Vectors;

public class SSNLOperator
implements LinearGraphOperator {
    private final Graph graph;
    private final double[] weights;
    private final double[] argument;
    private final CanonicalLinearOperator linOp;
    private final double[] v0;

    public SSNLOperator(Graph graph) {
        this.graph = graph;
        this.weights = graph.weights();
        this.v0 = SSNLOperator.computeV0(graph);
        this.argument = new double[graph.order()];
        this.linOp = new CanonicalLinearOperator(graph);
    }

    @VisibleForTesting
    static double[] computeV0(Graph graph) {
        double[] v0 = new double[graph.order()];
        double norm = Math.sqrt(graph.totalWeight());
        for (int i = 0; i < graph.order(); ++i) {
            v0[i] = Math.sqrt(graph.weights()[i]) / norm;
        }
        return v0;
    }

    @Override
    public double[] apply(double[] x) {
        double mu = 2.0 * Vectors.scalarProduct(this.v0, x);
        for (int i = 0; i < this.graph.order(); ++i) {
            this.argument[i] = x[i] / Math.sqrt(this.weights[i]);
        }
        double[] result = this.linOp.apply(this.argument);
        for (int i = 0; i < this.graph.order(); ++i) {
            result[i] = x[i] + result[i] / Math.sqrt(this.weights[i]) - mu * this.v0[i];
        }
        return result;
    }

    @Override
    public int size() {
        return this.graph.order();
    }
}

