/*
 * Decompiled with CFR 0.152.
 */
package net.adeptropolis.frogspawn.graphs.operators;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import net.adeptropolis.frogspawn.graphs.Graph;
import net.adeptropolis.frogspawn.graphs.operators.LinearGraphOperator;
import net.adeptropolis.frogspawn.graphs.traversal.EdgeConsumer;

public class CanonicalLinearOperator
implements LinearGraphOperator,
EdgeConsumer {
    private final Graph graph;
    private final double[] result;
    private double[] argument;

    public CanonicalLinearOperator(Graph graph) {
        this.graph = graph;
        this.result = new double[graph.order()];
    }

    @Override
    public double[] apply(double[] argument) {
        Arrays.fill(this.result, 0.0);
        Preconditions.checkArgument((argument.length == this.graph.order() ? 1 : 0) != 0, (Object)"Argument length mismatch");
        this.argument = argument;
        this.graph.traverseParallel(this);
        return this.result;
    }

    @Override
    public int size() {
        return this.graph.order();
    }

    @Override
    public void accept(int u, int v, double weight) {
        int n = u;
        this.result[n] = this.result[n] + weight * this.argument[v];
    }
}

