/*
 * Decompiled with CFR 0.152.
 */
package net.adeptropolis.frogspawn.graphs.labeled;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.adeptropolis.frogspawn.graphs.labeled.LabeledGraph;
import net.adeptropolis.frogspawn.graphs.labeled.LabeledGraphBuilder;

public class LabeledGraphSource {
    private static final Pattern TSVParsePattern = Pattern.compile("\\s*(?<weight>[0-9.]+)\t+(?<u>[^\t]+)\t+(?<v>.+)\\s*");

    private LabeledGraphSource() {
    }

    public static LabeledGraph<String> fromTSV(Stream<String> lines) {
        LabeledGraphBuilder<String> builder = new LabeledGraphBuilder<String>(String.class);
        lines.forEach(line -> {
            Matcher matcher = TSVParsePattern.matcher((CharSequence)line);
            if (matcher.find() && matcher.groupCount() == 3) {
                String weight = matcher.group("weight");
                builder.add(matcher.group("u"), matcher.group("v"), Double.parseDouble(weight));
            }
        });
        return builder.build();
    }
}

