/*
 * Decompiled with CFR 0.152.
 */
package net.adeptropolis.frogspawn.graphs.labeled;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.reflect.Array;
import net.adeptropolis.frogspawn.graphs.implementations.CompressedSparseGraph;
import net.adeptropolis.frogspawn.graphs.implementations.CompressedSparseGraphBuilder;
import net.adeptropolis.frogspawn.graphs.labeled.LabeledGraph;

public class LabeledGraphBuilder<V> {
    private final Object2IntOpenHashMap<V> vertexMap;
    private final CompressedSparseGraphBuilder builder;
    private final Class<V> labelClass;

    public LabeledGraphBuilder(Class<V> labelClass) {
        this.labelClass = labelClass;
        this.vertexMap = new Object2IntOpenHashMap();
        this.builder = new CompressedSparseGraphBuilder();
    }

    public LabeledGraphBuilder<V> add(V left, V right, double weight) {
        this.builder.add(this.vertexId(left), this.vertexId(right), weight);
        return this;
    }

    public LabeledGraph<V> build() {
        CompressedSparseGraph graph = this.builder.build();
        V[] labels = this.invertLabels();
        return new LabeledGraph<V>(graph, labels);
    }

    private V[] invertLabels() {
        Object[] map = (Object[])Array.newInstance(this.labelClass, this.vertexMap.size());
        this.vertexMap.forEach((label, id) -> {
            map[id.intValue()] = label;
        });
        return map;
    }

    private int vertexId(V label) {
        return this.vertexMap.computeIntIfAbsent(label, x -> this.vertexMap.size());
    }
}

