/*
 * Decompiled with CFR 0.152.
 */
package net.adeptropolis.frogspawn.graphs.implementations.arrays;

import net.adeptropolis.frogspawn.graphs.implementations.arrays.BigInts;

public class InterpolationSearch {
    private InterpolationSearch() {
    }

    public static long search(BigInts ints, int key, long low, long high) {
        int lowVal = ints.get(low);
        if (lowVal == key) {
            return low;
        }
        int highVal = ints.get(high);
        while (key >= lowVal && key <= highVal) {
            long mid = (int)(low + (long)(key - lowVal) * (high - low) / (long)(highVal - lowVal));
            int midVal = ints.get(mid);
            if (key > midVal) {
                low = mid + 1L;
                lowVal = ints.get(low);
                continue;
            }
            if (key < midVal) {
                high = mid - 1L;
                highVal = ints.get(high);
                continue;
            }
            return mid;
        }
        return -1L;
    }

    public static int search(int[] array, int key, int low, int high) {
        int lowVal = array[low];
        if (lowVal == key) {
            return low;
        }
        int highVal = array[high];
        while (key >= lowVal && key <= highVal) {
            int mid = (int)((long)low + (long)(key - lowVal) * (long)(high - low) / (long)(highVal - lowVal));
            int midVal = array[mid];
            if (key > midVal) {
                low = mid + 1;
                lowVal = array[low];
                continue;
            }
            if (key < midVal) {
                high = mid - 1;
                highVal = array[high];
                continue;
            }
            return mid;
        }
        return -1;
    }
}

