/*
 * Decompiled with CFR 0.152.
 */
package net.adeptropolis.frogspawn.graphs.implementations.arrays;

import it.unimi.dsi.fastutil.BigArrays;
import it.unimi.dsi.fastutil.BigSwapper;
import it.unimi.dsi.fastutil.longs.LongComparator;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class BigDoubles
implements LongComparator,
BigSwapper {
    static final int BIN_BITS = 17;
    private static final int BIN_MASK = 131071;
    private static final long GROWTH_FACTOR = 2L;
    private double[][] data = null;
    private long size = 0L;

    public BigDoubles(long initialCapacity) {
        this.resize(initialCapacity);
    }

    public static BigDoubles of(double ... values) {
        BigDoubles doubles = new BigDoubles(values.length);
        for (int i = 0; i < values.length; ++i) {
            doubles.set(i, values[i]);
        }
        return doubles;
    }

    public void resize(long capacity) {
        int currentBins = this.data != null ? this.data.length : 0;
        int requestedBins = Math.max(1, (int)((capacity - 1L >> 17) + 1L));
        if (requestedBins == currentBins) {
            return;
        }
        double[][] newData = new double[requestedBins][];
        if (this.data != null) {
            System.arraycopy(this.data, 0, newData, 0, Math.min(currentBins, requestedBins));
        }
        for (int i = currentBins; i < requestedBins; ++i) {
            newData[i] = new double[131072];
        }
        if (currentBins > requestedBins) {
            this.size = capacity;
        }
        this.data = newData;
    }

    public double get(long idx) {
        return this.data[(int)(idx >> 17)][(int)(idx & 0x1FFFFL)];
    }

    public void set(long idx, double value) {
        int bin = (int)(idx >> 17);
        if (this.data == null || bin >= this.data.length) {
            this.resize(2L * idx);
        }
        if (idx >= this.size) {
            this.size = idx + 1L;
        }
        this.data[bin][(int)(idx & 0x1FFFFL)] = value;
    }

    public long size() {
        return this.size;
    }

    public BigDoubles sort() {
        BigArrays.mergeSort((long)0L, (long)this.size, (LongComparator)this, (BigSwapper)this);
        return this;
    }

    int bins() {
        return this.data.length;
    }

    public int compare(long idx1, long idx2) {
        return Double.compare(this.get(idx1), this.get(idx2));
    }

    public void swap(long idx1, long idx2) {
        double val1 = this.get(idx1);
        double val2 = this.get(idx2);
        this.set(idx1, val2);
        this.set(idx2, val1);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BigDoubles)) {
            return false;
        }
        BigDoubles other = (BigDoubles)obj;
        if (this.size != other.size) {
            return false;
        }
        int i = 0;
        while ((long)i < this.size) {
            if (this.get(i) != other.get(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        for (long i = 0L; i < this.size; ++i) {
            builder.append(this.get(i));
        }
        return builder.hashCode();
    }

    public String toString() {
        return LongStream.range(0L, this.size()).mapToObj(i -> String.valueOf(this.get(i))).collect(Collectors.joining(", "));
    }
}

