/*
 * Decompiled with CFR 0.152.
 */
package net.adeptropolis.frogspawn.graphs.implementations;

import com.google.common.annotations.VisibleForTesting;
import it.unimi.dsi.fastutil.BigArrays;
import it.unimi.dsi.fastutil.BigSwapper;
import it.unimi.dsi.fastutil.longs.LongComparator;
import net.adeptropolis.frogspawn.graphs.Graph;
import net.adeptropolis.frogspawn.graphs.implementations.CompressedSparseGraph;
import net.adeptropolis.frogspawn.graphs.implementations.CompressedSparseGraphDatastore;
import net.adeptropolis.frogspawn.graphs.implementations.GraphConstructionException;
import net.adeptropolis.frogspawn.graphs.implementations.arrays.BigDoubles;
import net.adeptropolis.frogspawn.graphs.implementations.arrays.BigInts;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressedSparseGraphBuilder
implements Graph.Builder {
    private static final Logger LOG = LoggerFactory.getLogger((String)CompressedSparseGraphBuilder.class.getSimpleName());
    private static final long INITIAL_SIZE = 0x1000000L;
    private static final long GROW_SIZE = 0x1000000L;
    private final double minWeight;
    private final BigInts[] edges = new BigInts[]{new BigInts(0x1000000L), new BigInts(0x1000000L)};
    private final BigDoubles weights = new BigDoubles(0x1000000L);
    private long size = 0x1000000L;
    private long ptr = 0L;

    public CompressedSparseGraphBuilder(double minWeight) {
        this.minWeight = minWeight;
    }

    public CompressedSparseGraphBuilder() {
        this(1.0);
    }

    @Override
    public CompressedSparseGraphBuilder add(int u, int v, double weight) {
        this.addDirected(u, v, weight);
        if (u != v) {
            this.addDirected(v, u, weight);
        }
        return this;
    }

    @Override
    public Graph.Builder addDirected(int u, int v, double weight) {
        if (weight < this.minWeight) {
            throw new GraphConstructionException(String.format("Tried to add an edge with weight < %.3f", this.minWeight));
        }
        this.set(this.ptr++, u, v, weight);
        return this;
    }

    private void set(long idx, int u, int v, double weight) {
        if (idx >= this.size) {
            this.resize(this.size + 0x1000000L);
        }
        this.edges[0].set(idx, u);
        this.edges[1].set(idx, v);
        this.weights.set(idx, weight);
    }

    private void resize(long newSize) {
        this.size = newSize;
        this.edges[0].resize(newSize);
        this.edges[1].resize(newSize);
        this.weights.resize(newSize);
    }

    @Override
    public CompressedSparseGraph build() {
        CompressedSparseGraphDatastore datastore = this.buildDatastore();
        return new CompressedSparseGraph(datastore);
    }

    @VisibleForTesting
    CompressedSparseGraphDatastore buildDatastore() {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        if (this.ptr == 0L) {
            return new CompressedSparseGraphDatastore(0, 0L, new long[0], new BigInts(0L), new BigDoubles(0L));
        }
        this.sort();
        this.reduce();
        this.compact();
        int graphSize = this.edges[0].get(this.ptr - 1L) + 1;
        long[] pointers = this.computePointers(graphSize);
        stopWatch.stop();
        LOG.info("Finished building graph with {} vertices and {} edges in {}", new Object[]{graphSize, this.ptr, stopWatch});
        return new CompressedSparseGraphDatastore(graphSize, this.ptr, pointers, this.edges[1], this.weights);
    }

    private void sort() {
        EdgeSortOps ops = new EdgeSortOps();
        BigArrays.mergeSort((long)0L, (long)this.ptr, (LongComparator)ops, (BigSwapper)ops);
    }

    private void reduce() {
        if (this.ptr == 0L) {
            return;
        }
        int[] currentEdge = new int[]{this.edges[0].get(0L), this.edges[1].get(0L)};
        double currentValue = this.weights.get(0L);
        int[] edge = new int[2];
        long writePtr = 0L;
        for (long scrollPtr = 1L; scrollPtr < this.ptr; ++scrollPtr) {
            edge[0] = this.edges[0].get(scrollPtr);
            edge[1] = this.edges[1].get(scrollPtr);
            double val = this.weights.get(scrollPtr);
            if (edge[0] == currentEdge[0] && edge[1] == currentEdge[1]) {
                currentValue += val;
                continue;
            }
            if (writePtr < scrollPtr) {
                this.set(writePtr++, currentEdge[0], currentEdge[1], currentValue);
            }
            currentEdge[0] = edge[0];
            currentEdge[1] = edge[1];
            currentValue = val;
        }
        this.set(writePtr++, currentEdge[0], currentEdge[1], currentValue);
        this.ptr = writePtr;
    }

    private void compact() {
        this.resize(this.ptr);
    }

    private long[] computePointers(int graphSize) {
        long[] pointers = new long[graphSize + 1];
        pointers[0] = 0L;
        pointers[graphSize] = this.ptr;
        int prevVertex = 0;
        for (long i = 0L; i < this.ptr; ++i) {
            int v = this.edges[0].get(i);
            if (v <= prevVertex) continue;
            for (int j = prevVertex + 1; j <= v; ++j) {
                pointers[j] = i;
            }
            prevVertex = v;
        }
        return pointers;
    }

    private class EdgeSortOps
    implements LongComparator,
    BigSwapper {
        private EdgeSortOps() {
        }

        public int compare(long idx1, long idx2) {
            int c = CompressedSparseGraphBuilder.this.edges[0].compare(idx1, idx2);
            return c != 0 ? c : CompressedSparseGraphBuilder.this.edges[1].compare(idx1, idx2);
        }

        public void swap(long idx1, long idx2) {
            CompressedSparseGraphBuilder.this.edges[0].swap(idx1, idx2);
            CompressedSparseGraphBuilder.this.edges[1].swap(idx1, idx2);
            CompressedSparseGraphBuilder.this.weights.swap(idx1, idx2);
        }
    }
}

