/*
 * Decompiled with CFR 0.152.
 */
package net.adeptropolis.frogspawn.graphs.implementations;

import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntIterators;
import net.adeptropolis.frogspawn.graphs.Graph;
import net.adeptropolis.frogspawn.graphs.VertexIterator;
import net.adeptropolis.frogspawn.graphs.implementations.CompressedInducedSparseSubgraph;
import net.adeptropolis.frogspawn.graphs.implementations.CompressedSparseGraphBuilder;
import net.adeptropolis.frogspawn.graphs.implementations.CompressedSparseGraphDatastore;
import net.adeptropolis.frogspawn.graphs.traversal.EdgeConsumer;
import net.adeptropolis.frogspawn.graphs.traversal.ParallelEdgeOps;

public class CompressedSparseGraph
extends Graph {
    private final CompressedSparseGraphDatastore datastore;

    public CompressedSparseGraph(CompressedSparseGraphDatastore datastore) {
        this.datastore = datastore;
    }

    public static CompressedSparseGraphBuilder builder() {
        return new CompressedSparseGraphBuilder();
    }

    @Override
    public int order() {
        return this.datastore.size();
    }

    @Override
    public long size() {
        return this.datastore.edges.size();
    }

    @Override
    public VertexIterator vertexIterator() {
        return new DefaultVertexIterator();
    }

    @Override
    public int[] collectVertices() {
        int[] vertices = new int[this.order()];
        for (int i = 0; i < this.order(); ++i) {
            vertices[i] = i;
        }
        return vertices;
    }

    @Override
    public IntIterator globalVertexIdIterator() {
        return IntIterators.fromTo((int)0, (int)this.order());
    }

    @Override
    public void traverseParallel(EdgeConsumer consumer) {
        ParallelEdgeOps.traverse(this, consumer);
    }

    @Override
    public void traverseIncidentEdges(int v, EdgeConsumer consumer) {
        if (this.order() == 0 || v < 0) {
            return;
        }
        long low = this.datastore.pointers[v];
        long high = this.datastore.pointers[v + 1];
        if (low == high) {
            return;
        }
        for (long ptr = low; ptr < high; ++ptr) {
            int rightEndpoint = this.datastore.edges.get(ptr);
            consumer.accept(v, rightEndpoint, this.datastore.weights.get(ptr));
            if (rightEndpoint + 1 >= this.order()) break;
        }
    }

    @Override
    public int localVertexId(int globalVertexId) {
        return globalVertexId;
    }

    @Override
    public int globalVertexId(int localVertexId) {
        return localVertexId;
    }

    @Override
    public Graph inducedSubgraph(IntIterator vertices) {
        return new CompressedInducedSparseSubgraph(this.datastore, vertices);
    }

    public class DefaultVertexIterator
    implements VertexIterator {
        int idx = 0;

        @Override
        public boolean hasNext() {
            return this.idx++ < CompressedSparseGraph.this.order();
        }

        @Override
        public int localId() {
            return this.idx - 1;
        }

        @Override
        public int globalId() {
            return this.idx - 1;
        }
    }
}

