/*
 * Decompiled with CFR 0.152.
 */
package net.adeptropolis.frogspawn.graphs.implementations;

import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntIterators;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import net.adeptropolis.frogspawn.graphs.Graph;
import net.adeptropolis.frogspawn.graphs.VertexIterator;
import net.adeptropolis.frogspawn.graphs.implementations.CompressedSparseGraphDatastore;
import net.adeptropolis.frogspawn.graphs.implementations.SubgraphVertexIterator;
import net.adeptropolis.frogspawn.graphs.implementations.arrays.InterpolationSearch;
import net.adeptropolis.frogspawn.graphs.traversal.EdgeConsumer;
import net.adeptropolis.frogspawn.graphs.traversal.ParallelEdgeOps;

public class CompressedInducedSparseSubgraph
extends Graph {
    private final CompressedSparseGraphDatastore datastore;
    private final int[] vertices;
    private long cachedNumEdges = -1L;

    CompressedInducedSparseSubgraph(CompressedSparseGraphDatastore datastore, IntIterator vertices) {
        this.datastore = datastore;
        this.vertices = IntIterators.unwrap((IntIterator)vertices);
        Arrays.parallelSort(this.vertices, 0, this.order());
    }

    @Override
    public int order() {
        return this.vertices.length;
    }

    @Override
    public long size() {
        if (this.cachedNumEdges >= 0L) {
            return this.cachedNumEdges;
        }
        EdgeCountingConsumer edgeCountingConsumer = new EdgeCountingConsumer();
        this.traverseParallel(edgeCountingConsumer);
        this.cachedNumEdges = edgeCountingConsumer.getCount();
        return this.cachedNumEdges;
    }

    @Override
    public VertexIterator vertexIterator() {
        return new SubgraphVertexIterator().reset(this.vertices);
    }

    @Override
    public int[] collectVertices() {
        return (int[])this.vertices.clone();
    }

    @Override
    public IntIterator globalVertexIdIterator() {
        return IntIterators.wrap((int[])this.vertices);
    }

    @Override
    public void traverseParallel(EdgeConsumer consumer) {
        ParallelEdgeOps.traverse(this, consumer);
    }

    @Override
    public void traverseIncidentEdges(int v, EdgeConsumer consumer) {
        long high;
        if (this.order() == 0 || v < 0) {
            return;
        }
        int globalId = this.globalVertexId(v);
        long low = this.datastore.pointers[globalId];
        if (low == (high = this.datastore.pointers[globalId + 1])) {
            return;
        }
        if ((long)this.order() > high - low) {
            this.traverseByAdjacent(v, consumer, low, high);
        } else {
            this.traverseByVertices(v, consumer, low, high);
        }
    }

    @Override
    public int localVertexId(int globalVertexId) {
        return InterpolationSearch.search(this.vertices, globalVertexId, 0, this.order() - 1);
    }

    @Override
    public int globalVertexId(int localVertexId) {
        return this.vertices[localVertexId];
    }

    private void traverseByAdjacent(int leftEndpoint, EdgeConsumer consumer, long low, long high) {
        int secPtr = 0;
        for (long ptr = low; ptr < high; ++ptr) {
            int rightEndpoint = InterpolationSearch.search(this.vertices, this.datastore.edges.get(ptr), secPtr, this.order() - 1);
            if (rightEndpoint >= 0) {
                consumer.accept(leftEndpoint, rightEndpoint, this.datastore.weights.get(ptr));
                secPtr = rightEndpoint + 1;
            }
            if (secPtr >= this.order()) break;
        }
    }

    private void traverseByVertices(int leftEndpoint, EdgeConsumer consumer, long low, long high) {
        long ptr = low;
        for (int i = 0; i < this.order(); ++i) {
            long retrievedIdx = InterpolationSearch.search(this.datastore.edges, this.vertices[i], ptr, high - 1L);
            if (retrievedIdx >= 0L && retrievedIdx < high) {
                consumer.accept(leftEndpoint, i, this.datastore.weights.get(retrievedIdx));
                ptr = retrievedIdx + 1L;
            }
            if (ptr >= high) break;
        }
    }

    @Override
    public Graph inducedSubgraph(IntIterator vertices) {
        return new CompressedInducedSparseSubgraph(this.datastore, vertices);
    }

    private static class EdgeCountingConsumer
    implements EdgeConsumer {
        private final AtomicLong cnt = new AtomicLong();

        EdgeCountingConsumer() {
        }

        @Override
        public void accept(int u, int v, double weight) {
            this.cnt.incrementAndGet();
        }

        long getCount() {
            return this.cnt.get();
        }
    }
}

