/*
 * Decompiled with CFR 0.152.
 */
package net.adeptropolis.frogspawn.graphs.algorithms.power_iteration;

import net.adeptropolis.frogspawn.graphs.algorithms.power_iteration.ConvergenceCriterion;
import net.adeptropolis.frogspawn.graphs.algorithms.power_iteration.PowerIterationException;
import net.adeptropolis.frogspawn.graphs.operators.LinearGraphOperator;
import net.adeptropolis.frogspawn.helpers.Vectors;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PowerIteration {
    private static final Logger LOG = LoggerFactory.getLogger((String)PowerIteration.class.getSimpleName());

    private PowerIteration() {
    }

    public static double[] apply(LinearGraphOperator op, ConvergenceCriterion convergenceCriterion, double[] initialVector, int maxIterations, boolean expectNegativeEigenvalues) throws MaxIterationsExceededException {
        double[] x = new double[op.size()];
        double[] y = initialVector;
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        int i = 0;
        while (true) {
            System.arraycopy(y, 0, x, 0, op.size());
            if (i >= maxIterations) {
                throw new MaxIterationsExceededException(String.format("Exceeded maximum number of iterations (%d)", maxIterations));
            }
            y = op.apply(x);
            if (expectNegativeEigenvalues) {
                Vectors.normalize2Sig(y);
            } else {
                Vectors.normalize2(y);
            }
            if (convergenceCriterion.satisfied(x, y, i)) {
                stopWatch.stop();
                LOG.trace("Power iteration for operator size {} finished after {} rounds in {}", new Object[]{op.size(), i + 1, stopWatch});
                return y;
            }
            ++i;
        }
    }

    public static class MaxIterationsExceededException
    extends PowerIterationException {
        MaxIterationsExceededException(String message) {
            super(message);
        }
    }
}

