/*
 * Decompiled with CFR 0.152.
 */
package net.adeptropolis.frogspawn.graphs.algorithms.power_iteration;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import net.adeptropolis.frogspawn.graphs.Graph;
import net.adeptropolis.frogspawn.graphs.algorithms.SignumSelectingIndexIterator;
import net.adeptropolis.frogspawn.graphs.algorithms.power_iteration.PartialConvergenceCriterion;
import net.adeptropolis.frogspawn.graphs.algorithms.power_iteration.PartialConvergencePostprocessingException;

public class ConstantSigTrailConvergence
implements PartialConvergenceCriterion {
    private final Graph graph;
    private final int trailSize;
    private final int threshold;
    private final byte[] prevSig;
    private final int[] constSigTrail;

    public ConstantSigTrailConvergence(Graph graph, int trailSize, double convergenceThreshold) {
        this.graph = graph;
        this.prevSig = new byte[graph.order()];
        this.constSigTrail = new int[graph.order()];
        this.trailSize = trailSize;
        this.threshold = (int)(convergenceThreshold * (double)graph.order());
        Arrays.fill(this.prevSig, (byte)-2);
        Arrays.fill(this.constSigTrail, 0);
    }

    @Override
    public boolean satisfied(double[] previous, double[] current, int iterations) {
        int converged = 0;
        for (int v = 0; v < this.graph.order(); ++v) {
            byte sig = (byte)Math.signum(current[v]);
            if (sig == this.prevSig[v]) {
                int n = v;
                this.constSigTrail[n] = this.constSigTrail[n] + 1;
                if (this.hasConstantTrail(v)) {
                    ++converged;
                }
            } else {
                this.constSigTrail[v] = 0;
            }
            this.prevSig[v] = sig;
        }
        return converged >= this.threshold;
    }

    @Override
    public void postprocess(double[] vec) throws PartialConvergencePostprocessingException {
        Preconditions.checkState((vec.length == this.graph.order() ? 1 : 0) != 0, (Object)"Vector length does not match graph size");
        Graph lGraph = this.extractPostprocessingSubgraph(vec, -1);
        Graph rGraph = this.extractPostprocessingSubgraph(vec, 1);
        if (lGraph.order() > 0 && rGraph.order() > 0) {
            this.classifyNonConvergent(vec, lGraph, rGraph);
        } else if (lGraph.order() > 0) {
            this.classifyNonConvergentFallback(vec, -1);
        } else if (rGraph.order() > 0) {
            this.classifyNonConvergentFallback(vec, 1);
        } else {
            throw new PartialConvergencePostprocessingException("Postprocessing failed: Both graphs are empty");
        }
    }

    private void classifyNonConvergentFallback(double[] vec, int selector) {
        for (int i = 0; i < vec.length; ++i) {
            if (this.hasConstantTrail(i)) continue;
            vec[i] = selector;
        }
    }

    private void classifyNonConvergent(double[] vec, Graph lGraph, Graph rGraph) {
        for (int i = 0; i < vec.length; ++i) {
            if (this.hasConstantTrail(i)) continue;
            vec[i] = this.relativeWeight(lGraph, i) >= this.relativeWeight(rGraph, i) ? -1.0 : 1.0;
        }
    }

    private double relativeWeight(Graph subgraph, int i) {
        return subgraph.weightForGlobalId(this.graph.globalVertexId(i)) / subgraph.totalWeight();
    }

    private Graph extractPostprocessingSubgraph(double[] vec, int selector) {
        SignumSelectingIndexIterator localIndices = new SignumSelectingIndexIterator(vec, selector, i -> !this.hasConstantTrail(i));
        return this.graph.localInducedSubgraph(localIndices);
    }

    private boolean hasConstantTrail(int i) {
        return this.constSigTrail[i] >= this.trailSize - 1;
    }

    public int getTrailSize() {
        return this.trailSize;
    }

    public int getThreshold() {
        return this.threshold;
    }
}

