/*
 * Decompiled with CFR 0.152.
 */
package net.adeptropolis.frogspawn.graphs.algorithms;

import java.util.function.Consumer;
import net.adeptropolis.frogspawn.ClusteringSettings;
import net.adeptropolis.frogspawn.graphs.Graph;
import net.adeptropolis.frogspawn.graphs.algorithms.SignumSelectingIndexIterator;
import net.adeptropolis.frogspawn.graphs.algorithms.power_iteration.PartialConvergenceCriterion;
import net.adeptropolis.frogspawn.graphs.algorithms.power_iteration.PowerIteration;
import net.adeptropolis.frogspawn.graphs.algorithms.power_iteration.PowerIterationException;
import net.adeptropolis.frogspawn.graphs.algorithms.power_iteration.RandomInitialVectorsSource;
import net.adeptropolis.frogspawn.graphs.operators.SSNLOperator;

public class SpectralBisector {
    private final ClusteringSettings settings;

    public SpectralBisector(ClusteringSettings settings) {
        this.settings = settings;
    }

    private static void yieldSubgraph(Graph graph, double[] v2, Consumer<Graph> consumer, int selectSignum) {
        SignumSelectingIndexIterator vertices = new SignumSelectingIndexIterator(v2, selectSignum, null);
        consumer.accept(graph.localInducedSubgraph(vertices));
    }

    public void bisect(Graph graph, int maxIterations, RandomInitialVectorsSource ivSource, Consumer<Graph> consumer) throws PowerIterationException {
        PartialConvergenceCriterion convergenceCriterion = this.settings.convergenceCriterionForGraph(graph);
        SSNLOperator ssnl = new SSNLOperator(graph);
        double[] iv = ivSource.generate(graph.order());
        double[] v2 = PowerIteration.apply(ssnl, convergenceCriterion, iv, maxIterations, false);
        convergenceCriterion.postprocess(v2);
        SpectralBisector.yieldSubgraph(graph, v2, consumer, 1);
        SpectralBisector.yieldSubgraph(graph, v2, consumer, -1);
    }
}

