/*
 * Decompiled with CFR 0.152.
 */
package net.adeptropolis.frogspawn.graphs.algorithms;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntLinkedOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.function.Consumer;
import net.adeptropolis.frogspawn.graphs.Graph;
import net.adeptropolis.frogspawn.graphs.traversal.EdgeConsumer;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectedComponents
implements EdgeConsumer {
    private static final Logger LOG = LoggerFactory.getLogger((String)ConnectedComponents.class.getSimpleName());
    private final Graph graph;
    private final IntLinkedOpenHashSet remaining;
    private final IntLinkedOpenHashSet componentQueue;
    private IntOpenHashSet component;

    private ConnectedComponents(Graph graph) {
        this.graph = graph;
        this.remaining = new IntLinkedOpenHashSet();
        this.componentQueue = new IntLinkedOpenHashSet();
        this.component = new IntOpenHashSet();
    }

    public static void find(Graph graph, Consumer<Graph> consumer) {
        new ConnectedComponents(graph).find(consumer);
    }

    private void find(Consumer<Graph> consumer) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        this.remaining.clear();
        for (int i = 0; i < this.graph.order(); ++i) {
            this.remaining.add(i);
        }
        int comps = 0;
        while (!this.remaining.isEmpty()) {
            int i = this.remaining.removeFirstInt();
            this.processComponent(i);
            Graph subgraph = this.graph.localInducedSubgraph(this.component.iterator());
            consumer.accept(subgraph);
            ++comps;
            this.remaining.removeAll((IntCollection)this.component);
        }
        stopWatch.stop();
        LOG.trace("Isolated {} connected components in {}", (Object)comps, (Object)stopWatch);
    }

    private void processComponent(int i) {
        this.component = new IntOpenHashSet();
        this.componentQueue.clear();
        this.componentQueue.add(i);
        while (!this.componentQueue.isEmpty()) {
            int j = this.componentQueue.removeFirstInt();
            this.component.add(j);
            this.graph.traverseIncidentEdges(j, this);
        }
    }

    @Override
    public void accept(int u, int v, double weight) {
        if (!this.componentQueue.contains(v) && !this.component.contains(v)) {
            this.componentQueue.add(v);
        }
    }
}

