/*
 * Decompiled with CFR 0.152.
 */
package net.adeptropolis.frogspawn.graphs;

import it.unimi.dsi.fastutil.ints.IntIterator;
import net.adeptropolis.frogspawn.graphs.VertexIterator;
import net.adeptropolis.frogspawn.graphs.VertexWeights;
import net.adeptropolis.frogspawn.graphs.traversal.EdgeConsumer;
import net.adeptropolis.frogspawn.graphs.traversal.ParallelEdgeOps;
import net.adeptropolis.frogspawn.graphs.traversal.ParallelVertexOps;
import net.adeptropolis.frogspawn.graphs.traversal.VertexConsumer;

public abstract class Graph {
    private double[] cachedWeights = null;
    private double cachedTotalWeight = -1.0;

    public abstract int order();

    public abstract long size();

    public abstract VertexIterator vertexIterator();

    public abstract int[] collectVertices();

    public abstract IntIterator globalVertexIdIterator();

    public abstract void traverseIncidentEdges(int var1, EdgeConsumer var2);

    public void traverseParallel(EdgeConsumer consumer) {
        ParallelEdgeOps.traverse(this, consumer);
    }

    public void traverseVerticesParallel(VertexConsumer consumer) {
        ParallelVertexOps.traverse(this, consumer);
    }

    public abstract int localVertexId(int var1);

    public abstract int globalVertexId(int var1);

    public boolean containsVertex(int globalVertexId) {
        return this.localVertexId(globalVertexId) >= 0;
    }

    public abstract Graph inducedSubgraph(IntIterator var1);

    public Graph localInducedSubgraph(IntIterator vertices) {
        return this.inducedSubgraph(new VertexMappingIterator(vertices));
    }

    public double[] weights() {
        if (this.cachedWeights == null) {
            this.cachedWeights = VertexWeights.compute(this);
        }
        return this.cachedWeights;
    }

    public double weightForGlobalId(int globalVertexId) {
        return this.weights()[this.localVertexId(globalVertexId)];
    }

    public double totalWeight() {
        if (this.cachedTotalWeight >= 0.0) {
            return this.cachedTotalWeight;
        }
        double[] weights = this.weights();
        double total = 0.0;
        for (int i = 0; i < this.order(); ++i) {
            total += weights[i];
        }
        this.cachedTotalWeight = total;
        return total;
    }

    class VertexMappingIterator
    implements IntIterator {
        private final IntIterator localIds;

        VertexMappingIterator(IntIterator localIds) {
            this.localIds = localIds;
        }

        public int nextInt() {
            return Graph.this.globalVertexId(this.localIds.nextInt());
        }

        public boolean hasNext() {
            return this.localIds.hasNext();
        }
    }

    public static interface Builder {
        public Builder add(int var1, int var2, double var3);

        public Builder addDirected(int var1, int var2, double var3);

        public Graph build();
    }
}

