/*
 * Decompiled with CFR 0.152.
 */
package net.adeptropolis.frogspawn.digest;

import it.unimi.dsi.fastutil.Arrays;
import it.unimi.dsi.fastutil.Swapper;
import it.unimi.dsi.fastutil.ints.IntComparator;
import net.adeptropolis.frogspawn.digest.DigestRanking;
import net.adeptropolis.frogspawn.helpers.Arr;

class MemberSortOps
implements IntComparator,
Swapper {
    private final int[] vertices;
    private final double[] weights;
    private final double[] scores;
    private final DigestRanking ranking;

    private MemberSortOps(int[] vertices, double[] weights, double[] scores, DigestRanking ranking) {
        this.vertices = vertices;
        this.weights = weights;
        this.scores = scores;
        this.ranking = ranking;
    }

    public static void sort(int[] vertices, double[] weights, double[] scores, DigestRanking ranking) {
        MemberSortOps ops = new MemberSortOps(vertices, weights, scores, ranking);
        Arrays.mergeSort((int)0, (int)vertices.length, (IntComparator)ops, (Swapper)ops);
    }

    public void swap(int i, int j) {
        Arr.swap(this.vertices, i, j);
        Arr.swap(this.weights, i, j);
        Arr.swap(this.scores, i, j);
    }

    public int compare(int i, int j) {
        return Double.compare(this.ranking.compute(this.vertices[j], this.weights[j], this.scores[j]), this.ranking.compute(this.vertices[i], this.weights[i], this.scores[i]));
    }
}

