/*
 * Decompiled with CFR 0.152.
 */
package net.adeptropolis.frogspawn.digest;

import net.adeptropolis.frogspawn.ClusteringSettings;
import net.adeptropolis.frogspawn.clustering.affiliation.VertexAffiliationMetric;
import net.adeptropolis.frogspawn.digest.DigestRanking;
import net.adeptropolis.frogspawn.digest.DigestRankings;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class DigesterSettings {
    private final ClusteringSettings clusteringSettings;
    private final int maxDigestSize;
    private final boolean aggregateDigests;
    private final DigestRanking digestRanking;

    private DigesterSettings(ClusteringSettings clusteringSettings, int maxDigestSize, boolean aggregateDigests, DigestRanking digestRanking) {
        this.clusteringSettings = clusteringSettings;
        this.maxDigestSize = maxDigestSize;
        this.aggregateDigests = aggregateDigests;
        this.digestRanking = digestRanking;
    }

    public static Builder builder(ClusteringSettings clusteringSettings) {
        return new Builder(clusteringSettings);
    }

    public int getMaxDigestSize() {
        return this.maxDigestSize;
    }

    public boolean doAggregateDigests() {
        return this.aggregateDigests;
    }

    public DigestRanking getDigestRanking() {
        return this.digestRanking;
    }

    public VertexAffiliationMetric getVertexAffiliationMetric() {
        return this.clusteringSettings.getVertexAffiliationMetric();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.NO_CLASS_NAME_STYLE).append("affiliationMetric", (Object)this.getVertexAffiliationMetric()).append("maxDigestSize", this.getMaxDigestSize()).append("aggregateDigests", this.doAggregateDigests()).append("digestRanking", (Object)this.getDigestRanking()).build();
    }

    public static class Builder {
        private final ClusteringSettings clusteringSettings;
        private int maxDigestSize = 0;
        private boolean aggregateDigests = false;
        private DigestRanking digestRanking = DigestRankings.DEFAULT_COMBINED_RANKING;

        public Builder(ClusteringSettings clusteringSettings) {
            this.clusteringSettings = clusteringSettings;
        }

        public Builder withMaxDigestSize(int maxDigestSize) {
            this.maxDigestSize = maxDigestSize;
            return this;
        }

        public Builder withAggregateDigests(boolean aggregateDigests) {
            this.aggregateDigests = aggregateDigests;
            return this;
        }

        public Builder withDigestRanking(DigestRanking digestRanking) {
            this.digestRanking = digestRanking;
            return this;
        }

        public DigesterSettings build() {
            return new DigesterSettings(this.clusteringSettings, this.maxDigestSize, this.aggregateDigests, this.digestRanking);
        }
    }
}

