/*
 * Decompiled with CFR 0.152.
 */
package net.adeptropolis.frogspawn.digest;

import java.util.function.Function;
import net.adeptropolis.frogspawn.digest.DigestRanking;

public class DigestRankings {
    public static final DigestRanking WEIGHT_RANKING = (vertexId, weight, score) -> weight;
    public static final DigestRanking SCORE_RANKING = (vertexId, weight, score) -> score;
    public static final Function<Double, DigestRanking> COMBINED_RANKING = weightExp -> (vertexId, weight, score) -> Math.pow(weight, weightExp) * score;
    public static final DigestRanking DEFAULT_COMBINED_RANKING = new DefaultCombinedRanking();

    private DigestRankings() {
    }

    private static class DefaultCombinedRanking
    implements DigestRanking {
        private DefaultCombinedRanking() {
        }

        @Override
        public double compute(int vertexId, double weight, double score) {
            return Math.pow(weight, 1.5) * score;
        }
    }
}

