/*
 * Decompiled with CFR 0.152.
 */
package net.adeptropolis.frogspawn.digest;

import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.adeptropolis.frogspawn.digest.DigestMapping;
import net.adeptropolis.frogspawn.digest.LabeledDigestMapping;

public class Digest {
    private final int[] vertices;
    private final double[] weights;
    private final double[] scores;
    private final int totalSize;

    Digest(int[] vertices, double[] weights, double[] scores, int totalSize) {
        this.vertices = vertices;
        this.weights = weights;
        this.scores = scores;
        this.totalSize = totalSize;
    }

    public int[] getVertices() {
        return this.vertices;
    }

    public double[] getWeights() {
        return this.weights;
    }

    public double[] getScores() {
        return this.scores;
    }

    public int size() {
        return this.vertices.length;
    }

    public int totalSize() {
        return this.totalSize;
    }

    public <T> Stream<T> map(DigestMapping<T> mapper) {
        return IntStream.range(0, this.size()).mapToObj(i -> mapper.map(this.vertices[i], this.weights[i], this.scores[i]));
    }

    public <V, T> Stream<T> map(LabeledDigestMapping<V, T> mapper, V[] labels) {
        return IntStream.range(0, this.size()).mapToObj(i -> mapper.map(labels[this.vertices[i]], this.weights[i], this.scores[i]));
    }
}

