/*
 * Decompiled with CFR 0.152.
 */
package net.adeptropolis.frogspawn.digest;

import net.adeptropolis.frogspawn.clustering.Cluster;
import net.adeptropolis.frogspawn.clustering.affiliation.VertexAffiliationMetric;
import net.adeptropolis.frogspawn.digest.Digest;
import net.adeptropolis.frogspawn.digest.DigestRanking;
import net.adeptropolis.frogspawn.digest.DigesterSettings;
import net.adeptropolis.frogspawn.digest.MemberSortOps;
import net.adeptropolis.frogspawn.graphs.Graph;
import net.adeptropolis.frogspawn.graphs.VertexIterator;
import net.adeptropolis.frogspawn.helpers.Arr;

public class ClusterDigester {
    private final VertexAffiliationMetric metric;
    private final int maxSize;
    private final boolean aggregate;
    private final DigestRanking ranking;

    public ClusterDigester(DigesterSettings settings) {
        this.metric = settings.getVertexAffiliationMetric();
        this.maxSize = settings.getMaxDigestSize();
        this.aggregate = settings.doAggregateDigests();
        this.ranking = settings.getDigestRanking();
    }

    public Digest digest(Cluster cluster) {
        return this.aggregate ? this.aggregateDigest(cluster) : this.remainderDigest(cluster);
    }

    private Digest aggregateDigest(Cluster cluster) {
        Graph aggregateGraph = cluster.aggregateGraph();
        int[] vertices = aggregateGraph.collectVertices();
        double[] weights = aggregateGraph.weights();
        double[] affiliationScores = this.metric.compute(cluster.rootGraph(), aggregateGraph);
        return this.finalizeDigest(vertices, weights, affiliationScores);
    }

    private Digest remainderDigest(Cluster cluster) {
        Graph aggregateGraph = cluster.aggregateGraph();
        Graph remainderGraph = cluster.remainderGraph();
        int[] vertices = remainderGraph.collectVertices();
        double[] weights = this.restrictedWeights(aggregateGraph, remainderGraph);
        double[] affiliationScores = this.metric.compute(cluster.rootGraph(), aggregateGraph, remainderGraph);
        return this.finalizeDigest(vertices, weights, affiliationScores);
    }

    private Digest finalizeDigest(int[] vertices, double[] weights, double[] affiliationScores) {
        MemberSortOps.sort(vertices, weights, affiliationScores, this.ranking);
        if (this.maxSize > 0) {
            return this.subsetDigest(vertices, weights, affiliationScores, vertices.length);
        }
        return new Digest(vertices, weights, affiliationScores, vertices.length);
    }

    private Digest subsetDigest(int[] vertices, double[] weights, double[] affiliationScores, int totalSize) {
        return new Digest(Arr.shrink(vertices, this.maxSize), Arr.shrink(weights, this.maxSize), Arr.shrink(affiliationScores, this.maxSize), totalSize);
    }

    private double[] restrictedWeights(Graph aggregateGraph, Graph remainderGraph) {
        double[] weights = new double[remainderGraph.order()];
        VertexIterator it = remainderGraph.vertexIterator();
        while (it.hasNext()) {
            weights[it.localId()] = aggregateGraph.weightForGlobalId(it.globalId());
        }
        return weights;
    }
}

