/*
 * Decompiled with CFR 0.152.
 */
package net.adeptropolis.frogspawn.clustering.postprocessing.postprocessors;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import net.adeptropolis.frogspawn.clustering.Cluster;
import net.adeptropolis.frogspawn.clustering.affiliation.VertexAffiliationMetric;
import net.adeptropolis.frogspawn.clustering.postprocessing.Postprocessor;
import net.adeptropolis.frogspawn.clustering.postprocessing.TreeTraversalMode;
import net.adeptropolis.frogspawn.graphs.Graph;
import net.adeptropolis.frogspawn.graphs.VertexIterator;

public class VertexAffiliationGuardingPostprocessor
implements Postprocessor {
    private final VertexAffiliationMetric vertexAffiliationMetric;
    private final int minClusterSize;
    private final double minVertexAffiliation;

    public VertexAffiliationGuardingPostprocessor(VertexAffiliationMetric vertexAffiliationMetric, int minClusterSize, double minVertexAffiliation) {
        this.vertexAffiliationMetric = vertexAffiliationMetric;
        this.minClusterSize = minClusterSize;
        this.minVertexAffiliation = minVertexAffiliation;
    }

    @Override
    public boolean apply(Cluster cluster) {
        Cluster parent = cluster.getParent();
        if (parent == null) {
            return false;
        }
        IntRBTreeSet clusterVertices = new IntRBTreeSet((IntCollection)cluster.getRemainder());
        Graph clusterGraph = cluster.aggregateGraph();
        IntRBTreeSet survivors = new IntRBTreeSet(clusterGraph.globalVertexIdIterator());
        Graph subgraph = clusterGraph;
        while (true) {
            int prevSize = clusterVertices.size();
            this.shiftUnaffiliatedVertices(clusterVertices, parent, survivors, subgraph);
            if (clusterVertices.size() < this.minClusterSize) {
                parent.addToRemainder((IntIterator)clusterVertices.iterator());
                parent.assimilateChild(cluster, false);
                return true;
            }
            if (clusterVertices.size() == prevSize) break;
            subgraph = cluster.rootGraph().inducedSubgraph((IntIterator)survivors.iterator());
        }
        if (clusterVertices.size() == cluster.getRemainder().size()) {
            return false;
        }
        cluster.setRemainder(new IntArrayList((IntCollection)clusterVertices));
        return true;
    }

    @Override
    public TreeTraversalMode traversalMode() {
        return TreeTraversalMode.LOCAL_BOTTOM_TO_TOP;
    }

    private void shiftUnaffiliatedVertices(IntRBTreeSet clusterVertices, Cluster parent, IntRBTreeSet survivors, Graph subgraph) {
        double[] affiliationScores = this.vertexAffiliationMetric.compute(parent.rootGraph(), subgraph);
        VertexIterator it = subgraph.vertexIterator();
        while (it.hasNext()) {
            if (!(affiliationScores[it.localId()] < this.minVertexAffiliation)) continue;
            if (clusterVertices.contains(it.globalId())) {
                parent.addToRemainder(it.globalId());
                clusterVertices.remove(it.globalId());
            }
            survivors.remove(it.globalId());
        }
    }
}

