/*
 * Decompiled with CFR 0.152.
 */
package net.adeptropolis.frogspawn.clustering.postprocessing.postprocessors;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.PriorityQueue;
import java.util.Set;
import net.adeptropolis.frogspawn.clustering.Cluster;
import net.adeptropolis.frogspawn.clustering.postprocessing.OrderedBTTQueueFactory;
import net.adeptropolis.frogspawn.clustering.postprocessing.Postprocessor;
import net.adeptropolis.frogspawn.clustering.postprocessing.TreeTraversalMode;

public class SingletonRedistributionPostprocessor
implements Postprocessor {
    private static boolean processQueue(PriorityQueue<Cluster> queue, Set<Cluster> enqueued) {
        boolean changed = false;
        while (!queue.isEmpty()) {
            Cluster cluster = queue.poll();
            changed |= SingletonRedistributionPostprocessor.processCluster(cluster, queue, enqueued);
        }
        return changed;
    }

    private static void enqueueLeafs(Cluster root, PriorityQueue<Cluster> queue, Set<Cluster> enqueued) {
        root.traverse(cluster -> {
            if (cluster.getChildren().isEmpty()) {
                SingletonRedistributionPostprocessor.enqueue(cluster, queue, enqueued);
            }
        });
    }

    private static boolean processCluster(Cluster cluster, PriorityQueue<Cluster> queue, Set<Cluster> enqueued) {
        if (cluster.getParent() == null) {
            return false;
        }
        Cluster nearestNonTrivialAncestor = SingletonRedistributionPostprocessor.findClosestNonTrivialAncestor(cluster);
        if (nearestNonTrivialAncestor == null) {
            return false;
        }
        SingletonRedistributionPostprocessor.enqueue(nearestNonTrivialAncestor, queue, enqueued);
        if (nearestNonTrivialAncestor.equals(cluster.getParent())) {
            return false;
        }
        SingletonRedistributionPostprocessor.redistributeChain(cluster, nearestNonTrivialAncestor);
        return true;
    }

    private static void redistributeChain(Cluster cluster, Cluster designatedParent) {
        ArrayList chain = Lists.newArrayList();
        Cluster ptr = cluster;
        while (!ptr.getParent().equals(designatedParent)) {
            chain.add(ptr);
            ptr = ptr.getParent();
        }
        for (Cluster ptr2 : chain) {
            designatedParent.annex(ptr2);
        }
    }

    private static Cluster findClosestNonTrivialAncestor(Cluster cluster) {
        for (Cluster ancestor = cluster.getParent(); ancestor != null; ancestor = ancestor.getParent()) {
            if (ancestor.getChildren().size() < 2) continue;
            return ancestor;
        }
        return null;
    }

    private static void enqueue(Cluster cluster, PriorityQueue<Cluster> queue, Set<Cluster> enqueued) {
        if (!enqueued.contains(cluster)) {
            queue.add(cluster);
            enqueued.add(cluster);
        }
    }

    @Override
    public boolean apply(Cluster root) {
        PriorityQueue<Cluster> queue = OrderedBTTQueueFactory.queue();
        HashSet<Cluster> enqueued = new HashSet<Cluster>();
        SingletonRedistributionPostprocessor.enqueueLeafs(root, queue, enqueued);
        return SingletonRedistributionPostprocessor.processQueue(queue, enqueued);
    }

    @Override
    public TreeTraversalMode traversalMode() {
        return TreeTraversalMode.GLOBAL_CUSTOM;
    }
}

