/*
 * Decompiled with CFR 0.152.
 */
package net.adeptropolis.frogspawn.clustering.postprocessing;

import java.util.PriorityQueue;
import net.adeptropolis.frogspawn.clustering.Cluster;
import net.adeptropolis.frogspawn.clustering.postprocessing.OrderedBTTQueueFactory;
import net.adeptropolis.frogspawn.clustering.postprocessing.PostprocessingException;
import net.adeptropolis.frogspawn.clustering.postprocessing.Postprocessor;

public class PostprocessingTraversal {
    private PostprocessingTraversal() {
    }

    public static boolean apply(Postprocessor postprocessor, Cluster rootCluster) {
        switch (postprocessor.traversalMode()) {
            case LOCAL_BOTTOM_TO_TOP: {
                return PostprocessingTraversal.processQueueBTT(postprocessor, rootCluster);
            }
            case GLOBAL_CUSTOM: {
                return postprocessor.apply(rootCluster);
            }
        }
        throw new PostprocessingException(String.format("Unsupported tree traversal type: %s", new Object[]{postprocessor.traversalMode()}));
    }

    private static boolean processQueueBTT(Postprocessor postprocessor, Cluster rootCluster) {
        PriorityQueue<Cluster> queue = OrderedBTTQueueFactory.queue(rootCluster);
        boolean changed = false;
        while (!queue.isEmpty()) {
            Cluster cluster = queue.poll();
            if (!rootCluster.aggregateClusters().contains(cluster)) continue;
            changed |= postprocessor.apply(cluster);
        }
        return changed;
    }
}

