/*
 * Decompiled with CFR 0.152.
 */
package net.adeptropolis.frogspawn.clustering.postprocessing;

import com.google.common.collect.Lists;
import java.util.List;
import net.adeptropolis.frogspawn.ClusteringSettings;
import net.adeptropolis.frogspawn.clustering.affiliation.VertexAffiliationMetric;
import net.adeptropolis.frogspawn.clustering.postprocessing.Postprocessor;
import net.adeptropolis.frogspawn.graphs.similarity.GraphSimilarityMetric;
import net.adeptropolis.frogspawn.graphs.similarity.OverlapGraphSimilarityMetric;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class PostprocessingSettings {
    private final ClusteringSettings clusteringSettings;
    private final GraphSimilarityMetric similarityMetric;
    private final int minChildren;
    private final List<Postprocessor> customPostprocessors;

    private PostprocessingSettings(ClusteringSettings clusteringSettings, GraphSimilarityMetric similarityMetric, int minChildren, List<Postprocessor> customPostprocessors) {
        this.clusteringSettings = clusteringSettings;
        this.similarityMetric = similarityMetric;
        this.minChildren = minChildren;
        this.customPostprocessors = customPostprocessors;
    }

    public static Builder builder(ClusteringSettings clusteringSettings) {
        return new Builder(clusteringSettings);
    }

    public VertexAffiliationMetric getVertexAffiliationMetric() {
        return this.clusteringSettings.getVertexAffiliationMetric();
    }

    public GraphSimilarityMetric getSimilarityMetric() {
        return this.similarityMetric;
    }

    public double getMinVertexAffiliation() {
        return this.clusteringSettings.getMinVertexAffiliation();
    }

    public int getMinClusterSize() {
        return this.clusteringSettings.getMinClusterSize();
    }

    public int getMinChildren() {
        return this.minChildren;
    }

    public List<Postprocessor> getCustomPostprocessors() {
        return this.customPostprocessors;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.NO_CLASS_NAME_STYLE).append("affiliationMetric", (Object)this.getVertexAffiliationMetric()).append("minVertexAffiliation", this.getMinVertexAffiliation()).append("similarityMetric", (Object)this.getSimilarityMetric()).append("minClusterSize", this.getMinClusterSize()).append("minChildren", this.getMinChildren()).append("customPostprocessors", this.getCustomPostprocessors()).build();
    }

    public static class Builder {
        private final ClusteringSettings clusteringSettings;
        private final List<Postprocessor> customPostprocessors = Lists.newArrayList();
        private GraphSimilarityMetric similarityMetric = new OverlapGraphSimilarityMetric();
        private int minChildren = 10;

        public Builder(ClusteringSettings clusteringSettings) {
            this.clusteringSettings = clusteringSettings;
        }

        public Builder withSimilarityMetric(GraphSimilarityMetric metric) {
            this.similarityMetric = metric;
            return this;
        }

        public Builder withMinChildren(int minChildren) {
            this.minChildren = minChildren;
            return this;
        }

        public Builder withCustomPostprocessor(Postprocessor postprocessor) {
            this.customPostprocessors.add(postprocessor);
            return this;
        }

        public PostprocessingSettings build() {
            return new PostprocessingSettings(this.clusteringSettings, this.similarityMetric, this.minChildren, this.customPostprocessors);
        }
    }
}

