/*
 * Decompiled with CFR 0.152.
 */
package net.adeptropolis.frogspawn.clustering.postprocessing;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.adeptropolis.frogspawn.clustering.Cluster;
import net.adeptropolis.frogspawn.clustering.postprocessing.PostprocessingSettings;
import net.adeptropolis.frogspawn.clustering.postprocessing.PostprocessingTraversal;
import net.adeptropolis.frogspawn.clustering.postprocessing.Postprocessor;
import net.adeptropolis.frogspawn.clustering.postprocessing.postprocessors.DescendantCollapsingPostprocessor;
import net.adeptropolis.frogspawn.clustering.postprocessing.postprocessors.RemainderSizePostprocessor;
import net.adeptropolis.frogspawn.clustering.postprocessing.postprocessors.SingletonCollapsingPostprocessor;
import net.adeptropolis.frogspawn.clustering.postprocessing.postprocessors.SingletonRedistributionPostprocessor;
import net.adeptropolis.frogspawn.clustering.postprocessing.postprocessors.VertexAffiliationGuardingPostprocessor;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Postprocessing {
    private static final Logger LOG = LoggerFactory.getLogger((String)Postprocessing.class.getSimpleName());
    private final Cluster rootCluster;
    private final List<Postprocessor> pipeline;

    private Postprocessing(Cluster rootCluster, PostprocessingSettings settings) {
        this.rootCluster = rootCluster;
        this.pipeline = Postprocessing.createPipeline(settings);
    }

    public static Cluster apply(Cluster rootCluster, PostprocessingSettings settings) {
        return new Postprocessing(rootCluster, settings).postprocess();
    }

    private static List<Postprocessor> createPipeline(PostprocessingSettings settings) {
        RemainderSizePostprocessor remainderSize = new RemainderSizePostprocessor(settings.getMinClusterSize());
        SingletonRedistributionPostprocessor singletonRedistribution = new SingletonRedistributionPostprocessor();
        VertexAffiliationGuardingPostprocessor affiliation = new VertexAffiliationGuardingPostprocessor(settings.getVertexAffiliationMetric(), settings.getMinClusterSize(), settings.getMinVertexAffiliation());
        DescendantCollapsingPostprocessor subclusterCount = new DescendantCollapsingPostprocessor(settings.getMinChildren());
        SingletonCollapsingPostprocessor singletons = new SingletonCollapsingPostprocessor();
        ArrayList pipeline = Lists.newArrayList((Object[])new Postprocessor[]{remainderSize, singletonRedistribution, subclusterCount, affiliation, remainderSize, singletons});
        pipeline.addAll(settings.getCustomPostprocessors());
        return pipeline;
    }

    private Cluster postprocess() {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        this.pipeline.forEach(this::applyPostprocessor);
        stopWatch.stop();
        LOG.info("Postprocessing finished after {}", (Object)stopWatch);
        return this.rootCluster;
    }

    private void applyPostprocessor(Postprocessor postprocessor) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        boolean changed = PostprocessingTraversal.apply(postprocessor, this.rootCluster);
        stopWatch.stop();
        LOG.debug("{} finished in {}. There were {} to the cluster hierarchy.", new Object[]{postprocessor.getClass().getSimpleName(), stopWatch, changed ? "changes" : "no changes"});
    }
}

