/*
 * Decompiled with CFR 0.152.
 */
package net.adeptropolis.frogspawn.clustering.affiliation;

import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import net.adeptropolis.frogspawn.clustering.Cluster;
import net.adeptropolis.frogspawn.clustering.affiliation.VertexAffiliationMetric;
import net.adeptropolis.frogspawn.graphs.Graph;
import net.adeptropolis.frogspawn.graphs.VertexIterator;

public class VertexAffiliationGuard {
    private final VertexAffiliationMetric metric;
    private final Graph graph;
    private final int minClusterSize;
    private final double minAffiliation;

    public VertexAffiliationGuard(VertexAffiliationMetric metric, Graph graph, int minClusterSize, double minAffiliation) {
        this.metric = metric;
        this.graph = graph;
        this.minClusterSize = minClusterSize;
        this.minAffiliation = minAffiliation;
    }

    public Graph ensure(Cluster parentCluster, Graph candidate) {
        IntRBTreeSet survivors = new IntRBTreeSet(candidate.globalVertexIdIterator());
        Graph subgraph = candidate;
        while (true) {
            int prevSize = survivors.size();
            this.shiftUnaffiliatedVertices(subgraph, parentCluster, survivors);
            if (survivors.size() < this.minClusterSize) {
                parentCluster.addToRemainder((IntIterator)survivors.iterator());
                return null;
            }
            if (survivors.size() == this.minClusterSize || survivors.size() == prevSize) {
                return subgraph;
            }
            subgraph = this.graph.inducedSubgraph((IntIterator)survivors.iterator());
        }
    }

    private void shiftUnaffiliatedVertices(Graph subgraph, Cluster parentCluster, IntRBTreeSet survivors) {
        double[] metrics = this.metric.compute(this.graph, subgraph);
        VertexIterator it = subgraph.vertexIterator();
        while (it.hasNext()) {
            if (!(metrics[it.localId()] < this.minAffiliation)) continue;
            parentCluster.addToRemainder(it.globalId());
            survivors.remove(it.globalId());
        }
    }
}

