/*
 * Decompiled with CFR 0.152.
 */
package net.adeptropolis.frogspawn.clustering.affiliation;

import net.adeptropolis.frogspawn.clustering.affiliation.VertexAffiliationMetric;
import net.adeptropolis.frogspawn.graphs.Graph;
import net.adeptropolis.frogspawn.graphs.VertexIterator;

public class RelativeWeightVertexAffiliationMetric
implements VertexAffiliationMetric {
    @Override
    public double[] compute(Graph supergraph, Graph subgraph) {
        double[] relWeights = new double[subgraph.order()];
        VertexIterator it = subgraph.vertexIterator();
        while (it.hasNext()) {
            double supergraphWeight = supergraph.weightForGlobalId(it.globalId());
            relWeights[it.localId()] = supergraphWeight != 0.0 ? subgraph.weights()[it.localId()] / supergraphWeight : 0.0;
        }
        return relWeights;
    }

    @Override
    public double[] compute(Graph supergraph, Graph subgraph, Graph subsubgraph) {
        double[] relWeights = new double[subsubgraph.order()];
        VertexIterator it = subsubgraph.vertexIterator();
        while (it.hasNext()) {
            double subgraphWeight = subgraph.weightForGlobalId(it.globalId());
            double supergraphWeight = supergraph.weightForGlobalId(it.globalId());
            relWeights[it.localId()] = supergraphWeight != 0.0 ? subgraphWeight / supergraphWeight : 0.0;
        }
        return relWeights;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

