/*
 * Decompiled with CFR 0.152.
 */
package net.adeptropolis.frogspawn.clustering;

import com.google.common.base.Preconditions;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.adeptropolis.frogspawn.ClusteringSettings;
import net.adeptropolis.frogspawn.clustering.Cluster;
import net.adeptropolis.frogspawn.clustering.Protocluster;
import net.adeptropolis.frogspawn.clustering.affiliation.VertexAffiliationGuard;
import net.adeptropolis.frogspawn.graphs.Graph;
import net.adeptropolis.frogspawn.graphs.algorithms.ConnectedComponents;
import net.adeptropolis.frogspawn.graphs.algorithms.SpectralBisector;
import net.adeptropolis.frogspawn.graphs.algorithms.power_iteration.PowerIterationException;
import net.adeptropolis.frogspawn.graphs.algorithms.power_iteration.RandomInitialVectorsSource;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecursiveClustering {
    private static final Logger LOG = LoggerFactory.getLogger((String)RecursiveClustering.class.getSimpleName());
    private final Graph graph;
    private final ClusteringSettings settings;
    private final SpectralBisector bisector;
    private final VertexAffiliationGuard vertexAffiliationGuard;
    private final RandomInitialVectorsSource ivSource;
    private final ConcurrentLinkedQueue<Protocluster> queue;

    private RecursiveClustering(Graph graph, ClusteringSettings settings) {
        this.graph = graph;
        this.settings = settings;
        this.bisector = new SpectralBisector(settings);
        this.queue = new ConcurrentLinkedQueue();
        this.vertexAffiliationGuard = new VertexAffiliationGuard(settings.getVertexAffiliationMetric(), graph, settings.getMinClusterSize(), settings.getMinVertexAffiliation());
        this.ivSource = new RandomInitialVectorsSource(settings.getRandomSeed());
    }

    public static Cluster run(Graph graph, ClusteringSettings settings) {
        return new RecursiveClustering(graph, settings).run();
    }

    public Cluster run() {
        LOG.info("Starting recursive clustering of {} vertices using settings: {}", (Object)this.graph.order(), (Object)this.settings);
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        Cluster root = new Cluster(this.graph);
        Protocluster initialProtocluster = new Protocluster(this.graph, Protocluster.GraphType.ROOT, root);
        this.queue.add(initialProtocluster);
        this.processQueue();
        stopWatch.stop();
        LOG.info("Finished clustering {} vertices after {}", (Object)this.graph.order(), (Object)stopWatch);
        return root;
    }

    private void processQueue() {
        while (!this.queue.isEmpty()) {
            Protocluster protocluster = this.queue.poll();
            if (protocluster.getGraphType() == Protocluster.GraphType.COMPONENT) {
                this.bisect(protocluster);
                continue;
            }
            this.decomposeComponents(protocluster);
        }
    }

    private void bisect(Protocluster protocluster) {
        try {
            this.bisector.bisect(protocluster.getGraph(), this.settings.getMaxIterations(), this.ivSource, partition -> this.processPartition(protocluster, (Graph)partition));
        }
        catch (PowerIterationException e) {
            if (protocluster.getGraph().size() >= (long)this.settings.getMinClusterSize()) {
                this.addTerminalChild(protocluster, protocluster.getGraph());
            } else {
                protocluster.getCluster().addToRemainder(protocluster.getGraph());
            }
            LOG.debug(String.format("%s. Not clustering any further.", e.getMessage()));
        }
    }

    private void processPartition(Protocluster protocluster, Graph partition) {
        if (partition.order() < this.settings.getMinClusterSize() || partition.order() == protocluster.getGraph().order()) {
            protocluster.getCluster().addToRemainder(partition);
        } else {
            Graph guaranteedAffiliationSubgraph = this.vertexAffiliationGuard.ensure(protocluster.getCluster(), partition);
            if (guaranteedAffiliationSubgraph != null) {
                this.processGuaranteedAffiliationSubgraph(protocluster, guaranteedAffiliationSubgraph);
            }
        }
    }

    private void processGuaranteedAffiliationSubgraph(Protocluster protocluster, Graph guaranteedAffiliationSubgraph) {
        if (guaranteedAffiliationSubgraph.size() > (long)this.settings.getMinClusterSize()) {
            this.enqueueProtocluster(Protocluster.GraphType.SPECTRAL, protocluster.getCluster(), guaranteedAffiliationSubgraph);
        } else {
            Preconditions.checkState((guaranteedAffiliationSubgraph.size() == (long)this.settings.getMinClusterSize() ? 1 : 0) != 0);
            this.addTerminalChild(protocluster, guaranteedAffiliationSubgraph);
        }
    }

    private void addTerminalChild(Protocluster protocluster, Graph graph) {
        Cluster child = new Cluster(protocluster.getCluster());
        child.addToRemainder(graph);
    }

    private void decomposeComponents(Protocluster protocluster) {
        ConnectedComponents.find(protocluster.getGraph(), component -> {
            if (component.order() == protocluster.getGraph().order()) {
                protocluster.setGraphTypeConnectedComponent();
                this.queue.add(protocluster);
            } else if (component.order() < this.settings.getMinClusterSize()) {
                protocluster.getCluster().addToRemainder((Graph)component);
            } else if (component.order() == this.settings.getMinClusterSize()) {
                this.addTerminalChild(protocluster, (Graph)component);
            } else if (component.order() > this.settings.getMinClusterSize()) {
                this.enqueueProtocluster(Protocluster.GraphType.COMPONENT, protocluster.getCluster(), (Graph)component);
            }
        });
    }

    private void enqueueProtocluster(Protocluster.GraphType graphType, Cluster parent, Graph subgraph) {
        Cluster childCluster = new Cluster(parent);
        Protocluster protocluster = new Protocluster(subgraph, graphType, childCluster);
        this.queue.add(protocluster);
    }
}

