/*
 * Decompiled with CFR 0.152.
 */
package net.adeptropolis.frogspawn.clustering;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.adeptropolis.frogspawn.graphs.Graph;
import net.adeptropolis.frogspawn.graphs.VertexIterator;

public class Cluster {
    private static final AtomicInteger CURR_ID = new AtomicInteger(Integer.MIN_VALUE);
    private static final Comparator<Cluster> DETERMINISTIC_CHILD_COMPARATOR = Comparator.comparingInt(Cluster::getId);
    private static final long HASH_MULTIPLIER_PRIME = 8388581L;
    private static final long HASH_MOD_PRIME = Integer.MAX_VALUE;
    private final SortedSet<Cluster> children;
    private final int id;
    private final Root root;
    private Cluster parent;
    private IntArrayList remainder;

    public Cluster(Graph rootGraph) {
        this.root = new Root(this, rootGraph);
        this.parent = null;
        this.children = new TreeSet<Cluster>(DETERMINISTIC_CHILD_COMPARATOR);
        this.remainder = new IntArrayList();
        this.id = CURR_ID.getAndIncrement();
    }

    public Cluster(Cluster parent) {
        this.parent = parent;
        this.parent.children.add(this);
        this.root = parent.root;
        this.children = new TreeSet<Cluster>(DETERMINISTIC_CHILD_COMPARATOR);
        this.remainder = new IntArrayList();
        this.id = CURR_ID.getAndIncrement();
    }

    public void assimilateChild(Cluster child, boolean assimilateRemainder) {
        this.children.remove(child);
        for (Cluster grandchild : child.children) {
            grandchild.parent = this;
        }
        this.children.addAll(child.getChildren());
        if (assimilateRemainder) {
            this.remainder.addAll((IntList)child.getRemainder());
        }
    }

    public void annex(Cluster cluster) {
        if (cluster.parent.children.remove(cluster)) {
            cluster.parent = this;
            this.children.add(cluster);
        }
    }

    public IntArrayList getRemainder() {
        return this.remainder;
    }

    public void setRemainder(IntArrayList remainder) {
        this.remainder = remainder;
    }

    public <T> Stream<T> remainderLabels(T[] labels) {
        return IntStream.range(0, this.remainder.size()).mapToObj(i -> labels[this.remainder.getInt(i)]);
    }

    public Set<Cluster> getChildren() {
        return this.children;
    }

    public Cluster getParent() {
        return this.parent;
    }

    public void addToRemainder(int globalId) {
        this.remainder.add(globalId);
    }

    public void addToRemainder(IntIterator it) {
        while (it.hasNext()) {
            this.addToRemainder(it.nextInt());
        }
    }

    void addToRemainder(Graph graph) {
        this.remainder.ensureCapacity(this.remainder.size() + graph.order());
        VertexIterator vertexIterator = graph.vertexIterator();
        while (vertexIterator.hasNext()) {
            this.remainder.add(vertexIterator.globalId());
        }
    }

    public void traverse(Consumer<Cluster> consumer) {
        consumer.accept(this);
        for (Cluster child : this.children) {
            child.traverse(consumer);
        }
    }

    public IntArrayList aggregateVertices() {
        IntArrayList vertices = new IntArrayList();
        this.traverse(cluster -> vertices.addAll((IntList)cluster.remainder));
        return vertices;
    }

    public int depth() {
        int depth = 0;
        Cluster ptr = this;
        while (ptr.getParent() != null) {
            ++depth;
            ptr = ptr.getParent();
        }
        return depth;
    }

    public int remainderSize() {
        return this.remainder.size();
    }

    public Cluster root() {
        return this.root.cluster;
    }

    public Graph rootGraph() {
        return this.root.graph;
    }

    public Graph aggregateGraph() {
        return this.root.graph.inducedSubgraph((IntIterator)this.aggregateVertices().iterator());
    }

    public Graph remainderGraph() {
        return this.root.graph.inducedSubgraph((IntIterator)this.remainder.iterator());
    }

    public Set<Cluster> aggregateClusters() {
        HashSet<Cluster> clusters = new HashSet<Cluster>();
        this.traverse(clusters::add);
        return clusters;
    }

    public int getId() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Cluster)) {
            return false;
        }
        Cluster other = (Cluster)obj;
        return other.getId() == this.getId();
    }

    public int hashCode() {
        return (int)(8388581L * (long)this.getId() % Integer.MAX_VALUE);
    }

    private static class Root {
        private final Cluster cluster;
        private final Graph graph;

        private Root(Cluster cluster, Graph graph) {
            this.cluster = cluster;
            this.graph = graph;
        }
    }
}

