/*
 * Decompiled with CFR 0.152.
 */
package net.adeptropolis.frogspawn;

import net.adeptropolis.frogspawn.clustering.affiliation.RelativeWeightVertexAffiliationMetric;
import net.adeptropolis.frogspawn.clustering.affiliation.VertexAffiliationMetric;
import net.adeptropolis.frogspawn.graphs.Graph;
import net.adeptropolis.frogspawn.graphs.algorithms.power_iteration.ConstantSigTrailConvergence;
import net.adeptropolis.frogspawn.graphs.algorithms.power_iteration.PartialConvergenceCriterion;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class ClusteringSettings {
    private final VertexAffiliationMetric vertexAffiliationMetric;
    private final double minVertexAffiliation;
    private final int minClusterSize;
    private final int trailSize;
    private final double convergenceThreshold;
    private final int maxIterations;
    private final long randomSeed;

    private ClusteringSettings(VertexAffiliationMetric vertexAffiliationMetric, double minVertexAffiliation, int minClusterSize, int trailSize, double convergenceThreshold, int maxIterations, long randomSeed) {
        this.vertexAffiliationMetric = vertexAffiliationMetric;
        this.minVertexAffiliation = minVertexAffiliation;
        this.minClusterSize = minClusterSize;
        this.trailSize = trailSize;
        this.convergenceThreshold = convergenceThreshold;
        this.maxIterations = maxIterations;
        this.randomSeed = randomSeed;
    }

    public static Builder builder() {
        return new Builder();
    }

    public double getMinVertexAffiliation() {
        return this.minVertexAffiliation;
    }

    public int getMinClusterSize() {
        return this.minClusterSize;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public long getRandomSeed() {
        return this.randomSeed;
    }

    public PartialConvergenceCriterion convergenceCriterionForGraph(Graph graph) {
        return new ConstantSigTrailConvergence(graph, this.trailSize, this.convergenceThreshold);
    }

    public VertexAffiliationMetric getVertexAffiliationMetric() {
        return this.vertexAffiliationMetric;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.NO_CLASS_NAME_STYLE).append("affiliationMetric", (Object)this.vertexAffiliationMetric).append("minVertexAffiliation", this.minVertexAffiliation).append("minClusterSize", this.minClusterSize).append("trailSize", this.trailSize).append("convergenceThreshold", this.convergenceThreshold).append("maxIterations", this.convergenceThreshold).append("randomSeed", this.randomSeed).build();
    }

    public static class Builder {
        private VertexAffiliationMetric vertexAffiliationMetric = new RelativeWeightVertexAffiliationMetric();
        private double minVertexAffiliation = 0.1;
        private int minClusterSize = 50;
        private int trailSize = 20;
        private double convergenceThreshold = 0.95;
        private long randomSeed = 0x282E8EEL;
        private int maxIterations = 540;

        public Builder withVertexAffiliationMetric(VertexAffiliationMetric metric) {
            this.vertexAffiliationMetric = metric;
            return this;
        }

        public Builder withMinVertexAffiliation(double minVertexAffiliation) {
            this.minVertexAffiliation = minVertexAffiliation;
            return this;
        }

        public Builder withMinClusterSize(int minClusterSize) {
            this.minClusterSize = minClusterSize;
            return this;
        }

        public Builder withTrailSize(int trailSize) {
            this.trailSize = trailSize;
            return this;
        }

        public Builder withConvergenceThreshold(double convergenceThreshold) {
            this.convergenceThreshold = convergenceThreshold;
            return this;
        }

        public Builder withMaxIterations(int maxIterations) {
            this.maxIterations = maxIterations;
            return this;
        }

        public Builder withRandomSeed(long seed) {
            this.randomSeed = seed;
            return this;
        }

        public ClusteringSettings build() {
            return new ClusteringSettings(this.vertexAffiliationMetric, this.minVertexAffiliation, this.minClusterSize, this.trailSize, this.convergenceThreshold, this.maxIterations, this.randomSeed);
        }
    }
}

