/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.xdevapi;

import com.mysql.cj.MysqlxSession;
import com.mysql.cj.protocol.x.StatementExecuteOk;
import com.mysql.cj.result.RowList;
import com.mysql.cj.xdevapi.DocFindParams;
import com.mysql.cj.xdevapi.DocResult;
import com.mysql.cj.xdevapi.DocResultImpl;
import com.mysql.cj.xdevapi.Expression;
import com.mysql.cj.xdevapi.FilterableStatement;
import com.mysql.cj.xdevapi.FindParams;
import com.mysql.cj.xdevapi.FindStatement;
import com.mysql.cj.xdevapi.Statement;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class FindStatementImpl
extends FilterableStatement<FindStatement, DocResult>
implements FindStatement {
    private MysqlxSession mysqlxSession;
    private DocFindParams findParams;

    FindStatementImpl(MysqlxSession mysqlxSession, String schema, String collection, String criteria) {
        super(new DocFindParams(schema, collection));
        this.findParams = (DocFindParams)this.filterParams;
        this.mysqlxSession = mysqlxSession;
        if (criteria != null && criteria.length() > 0) {
            this.findParams.setCriteria(criteria);
        }
    }

    @Override
    public DocResultImpl execute() {
        return this.mysqlxSession.find((FindParams)this.findParams, (rows, task) -> new DocResultImpl((RowList)rows, (Supplier<StatementExecuteOk>)task));
    }

    @Override
    public CompletableFuture<DocResult> executeAsync() {
        return this.mysqlxSession.asyncFind(this.findParams, metadata -> (rows, task) -> new DocResultImpl((RowList)rows, (Supplier<StatementExecuteOk>)task));
    }

    @Override
    public FindStatement fields(String ... projection) {
        this.findParams.setFields(projection);
        return this;
    }

    @Override
    public FindStatement fields(Expression docProjection) {
        this.findParams.setFields(docProjection);
        return this;
    }

    @Override
    public FindStatement groupBy(String ... groupBy) {
        this.findParams.setGrouping(groupBy);
        return this;
    }

    @Override
    public FindStatement having(String having) {
        this.findParams.setGroupingCriteria(having);
        return this;
    }

    @Override
    public FindStatement lockShared() {
        return this.lockShared(Statement.LockContention.DEFAULT);
    }

    @Override
    public FindStatement lockShared(Statement.LockContention lockContention) {
        this.findParams.setLock(FindParams.RowLock.SHARED_LOCK);
        switch (lockContention) {
            case NOWAIT: {
                this.findParams.setLockOption(FindParams.RowLockOptions.NOWAIT);
                break;
            }
            case SKIP_LOCKED: {
                this.findParams.setLockOption(FindParams.RowLockOptions.SKIP_LOCKED);
                break;
            }
        }
        return this;
    }

    @Override
    public FindStatement lockExclusive() {
        return this.lockExclusive(Statement.LockContention.DEFAULT);
    }

    @Override
    public FindStatement lockExclusive(Statement.LockContention lockContention) {
        this.findParams.setLock(FindParams.RowLock.EXCLUSIVE_LOCK);
        switch (lockContention) {
            case NOWAIT: {
                this.findParams.setLockOption(FindParams.RowLockOptions.NOWAIT);
                break;
            }
            case SKIP_LOCKED: {
                this.findParams.setLockOption(FindParams.RowLockOptions.SKIP_LOCKED);
                break;
            }
        }
        return this;
    }
}

