/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.conf;

import com.mysql.cj.conf.MemorySizePropertyDefinition;
import com.mysql.cj.conf.ModifiableProperty;
import com.mysql.cj.conf.PropertyDefinition;
import com.mysql.cj.conf.ReadableMemorySizeProperty;
import com.mysql.cj.exceptions.ExceptionFactory;
import com.mysql.cj.exceptions.ExceptionInterceptor;
import com.mysql.cj.exceptions.WrongArgumentException;
import java.io.Serializable;

public class ModifiableMemorySizeProperty
extends ReadableMemorySizeProperty
implements ModifiableProperty<Integer>,
Serializable {
    private static final long serialVersionUID = -8018059699460539279L;
    private String initialValueAsString;

    protected ModifiableMemorySizeProperty(PropertyDefinition<Integer> propertyDefinition) {
        super(propertyDefinition);
    }

    @Override
    public void setFromString(String value, ExceptionInterceptor exceptionInterceptor) {
        this.setValue(((MemorySizePropertyDefinition)this.getPropertyDefinition()).parseObject(value, exceptionInterceptor), value, exceptionInterceptor);
        this.valueAsString = value;
    }

    @Override
    protected void initializeFrom(String extractedValue, ExceptionInterceptor exceptionInterceptor) {
        super.initializeFrom(extractedValue, exceptionInterceptor);
        this.initialValue = this.value;
        this.initialValueAsString = this.valueAsString;
    }

    @Override
    public void setValue(Integer value) {
        this.setValue(value, null, null);
    }

    @Override
    public void setValue(Integer value, ExceptionInterceptor exceptionInterceptor) {
        this.setValue(value, null, exceptionInterceptor);
    }

    void setValue(int intValue, String valueAsString, ExceptionInterceptor exceptionInterceptor) {
        if (this.getPropertyDefinition().isRangeBased() && (intValue < this.getPropertyDefinition().getLowerBound() || intValue > this.getPropertyDefinition().getUpperBound())) {
            throw ExceptionFactory.createException(WrongArgumentException.class, "The connection property '" + this.getPropertyDefinition().getName() + "' only accepts integer values in the range of " + this.getPropertyDefinition().getLowerBound() + " - " + this.getPropertyDefinition().getUpperBound() + ", the value '" + (valueAsString == null ? Integer.valueOf(intValue) : valueAsString) + "' exceeds this range.", exceptionInterceptor);
        }
        this.value = intValue;
        this.valueAsString = valueAsString == null ? String.valueOf(intValue) : valueAsString;
        this.wasExplicitlySet = true;
        this.invokeListeners();
    }

    @Override
    public void resetValue() {
        this.value = this.initialValue;
        this.valueAsString = this.initialValueAsString;
        this.invokeListeners();
    }
}

