/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.mysqla.io;

import com.mysql.cj.api.io.PacketBuffer;
import com.mysql.cj.core.Constants;
import com.mysql.cj.core.Messages;
import com.mysql.cj.core.exceptions.ExceptionFactory;
import com.mysql.cj.core.exceptions.WrongArgumentException;
import com.mysql.cj.core.util.StringUtils;
import java.nio.ByteBuffer;

public class Buffer
implements PacketBuffer {
    static final int MAX_BYTES_TO_DUMP = 512;
    static final int NO_LENGTH_LIMIT = -1;
    public static final long NULL_LENGTH = -1L;
    private int bufLength = 0;
    private byte[] byteBuffer;
    private int position = 0;
    protected boolean wasMultiPacket = false;

    public Buffer(byte[] buf) {
        this.byteBuffer = buf;
        this.setBufLength(buf.length);
    }

    public Buffer(int size) {
        this.byteBuffer = new byte[size];
        this.setBufLength(this.byteBuffer.length);
        this.position = 4;
    }

    public final void clear() {
        this.position = 4;
    }

    final void dump() {
        this.dump(this.getBufLength());
    }

    public final String dump(int numBytes) {
        return StringUtils.dumpAsHex(this.getBytes(0, numBytes > this.getBufLength() ? this.getBufLength() : numBytes), numBytes > this.getBufLength() ? this.getBufLength() : numBytes);
    }

    final String dumpClampedBytes(int numBytes) {
        int numBytesToDump = numBytes < 512 ? numBytes : 512;
        String dumped = StringUtils.dumpAsHex(this.getBytes(0, numBytesToDump > this.getBufLength() ? this.getBufLength() : numBytesToDump), numBytesToDump > this.getBufLength() ? this.getBufLength() : numBytesToDump);
        if (numBytesToDump < numBytes) {
            return dumped + " ....(packet exceeds max. dump length)";
        }
        return dumped;
    }

    public final void ensureCapacity(int additionalData) {
        if (this.position + additionalData > this.getBufLength()) {
            if (this.position + additionalData < this.byteBuffer.length) {
                this.setBufLength(this.byteBuffer.length);
            } else {
                int newLength = (int)((double)this.byteBuffer.length * 1.25);
                if (newLength < this.byteBuffer.length + additionalData) {
                    newLength = this.byteBuffer.length + (int)((double)additionalData * 1.25);
                }
                if (newLength < this.byteBuffer.length) {
                    newLength = this.byteBuffer.length + additionalData;
                }
                byte[] newBytes = new byte[newLength];
                System.arraycopy(this.byteBuffer, 0, newBytes, 0, this.byteBuffer.length);
                this.byteBuffer = newBytes;
                this.setBufLength(this.byteBuffer.length);
            }
        }
    }

    public int fastSkipLenString() {
        long len = this.readFieldLength();
        this.position = (int)((long)this.position + len);
        return (int)len;
    }

    public void fastSkipLenByteArray() {
        long len = this.readFieldLength();
        if (len == -1L || len == 0L) {
            return;
        }
        this.position = (int)((long)this.position + len);
    }

    protected final byte[] getBufferSource() {
        return this.byteBuffer;
    }

    @Override
    public int getBufLength() {
        return this.bufLength;
    }

    @Override
    public byte[] getByteBuffer() {
        return this.byteBuffer;
    }

    @Override
    public final byte[] getBytes(int len) {
        byte[] b = new byte[len];
        System.arraycopy(this.byteBuffer, this.position, b, 0, len);
        this.position += len;
        return b;
    }

    public byte[] getBytes(int offset, int len) {
        byte[] dest = new byte[len];
        System.arraycopy(this.byteBuffer, offset, dest, 0, len);
        return dest;
    }

    public int getCapacity() {
        return this.byteBuffer.length;
    }

    public ByteBuffer getNioBuffer() {
        throw new IllegalArgumentException(Messages.getString("ByteArrayBuffer.0"));
    }

    public int getPosition() {
        return this.position;
    }

    public final boolean isLastDataPacket() {
        return this.getBufLength() < 9 && (this.byteBuffer[0] & 0xFF) == 254;
    }

    public final boolean isAuthMethodSwitchRequestPacket() {
        return (this.byteBuffer[0] & 0xFF) == 254;
    }

    public final boolean isOKPacket() {
        return (this.byteBuffer[0] & 0xFF) == 0;
    }

    public final boolean isRawPacket() {
        return (this.byteBuffer[0] & 0xFF) == 1;
    }

    public final long readLength() {
        int sw = this.byteBuffer[this.position++] & 0xFF;
        switch (sw) {
            case 251: {
                return 0L;
            }
            case 252: {
                return this.readInt();
            }
            case 253: {
                return this.readLongInt();
            }
            case 254: {
                return this.readLongLong();
            }
        }
        return sw;
    }

    public final byte readByte() {
        return this.byteBuffer[this.position++];
    }

    public final byte readByte(int readAt) {
        return this.byteBuffer[readAt];
    }

    public final long readFieldLength() {
        int sw = this.byteBuffer[this.position++] & 0xFF;
        switch (sw) {
            case 251: {
                return -1L;
            }
            case 252: {
                return this.readInt();
            }
            case 253: {
                return this.readLongInt();
            }
            case 254: {
                return this.readLongLong();
            }
        }
        return sw;
    }

    public final int readInt() {
        byte[] b = this.byteBuffer;
        return b[this.position++] & 0xFF | (b[this.position++] & 0xFF) << 8;
    }

    public final int readIntAsLong() {
        byte[] b = this.byteBuffer;
        return b[this.position++] & 0xFF | (b[this.position++] & 0xFF) << 8 | (b[this.position++] & 0xFF) << 16 | (b[this.position++] & 0xFF) << 24;
    }

    public final byte[] readLenByteArray(int offset) {
        long len = this.readFieldLength();
        if (len == -1L) {
            return null;
        }
        if (len == 0L) {
            return Constants.EMPTY_BYTE_ARRAY;
        }
        this.position += offset;
        return this.getBytes((int)len);
    }

    public final long readLong() {
        byte[] b = this.byteBuffer;
        return (long)b[this.position++] & 0xFFL | ((long)b[this.position++] & 0xFFL) << 8 | (long)(b[this.position++] & 0xFF) << 16 | (long)(b[this.position++] & 0xFF) << 24;
    }

    final int readLongInt() {
        byte[] b = this.byteBuffer;
        return b[this.position++] & 0xFF | (b[this.position++] & 0xFF) << 8 | (b[this.position++] & 0xFF) << 16;
    }

    public final long readLongLong() {
        byte[] b = this.byteBuffer;
        return (long)(b[this.position++] & 0xFF) | (long)(b[this.position++] & 0xFF) << 8 | (long)(b[this.position++] & 0xFF) << 16 | (long)(b[this.position++] & 0xFF) << 24 | (long)(b[this.position++] & 0xFF) << 32 | (long)(b[this.position++] & 0xFF) << 40 | (long)(b[this.position++] & 0xFF) << 48 | (long)(b[this.position++] & 0xFF) << 56;
    }

    final int readnBytes() {
        int sw = this.byteBuffer[this.position++] & 0xFF;
        switch (sw) {
            case 1: {
                return this.byteBuffer[this.position++] & 0xFF;
            }
            case 2: {
                return this.readInt();
            }
            case 3: {
                return this.readLongInt();
            }
            case 4: {
                return (int)this.readLong();
            }
        }
        return 255;
    }

    @Override
    public final String readString() {
        int len = 0;
        int maxLen = this.getBufLength();
        for (int i = this.position; i < maxLen && this.byteBuffer[i] != 0; ++i) {
            ++len;
        }
        String s = StringUtils.toString(this.byteBuffer, this.position, len);
        this.position += len + 1;
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String readString(String encoding) {
        int len = 0;
        int maxLen = this.getBufLength();
        for (int i = this.position; i < maxLen && this.byteBuffer[i] != 0; ++i) {
            ++len;
        }
        try {
            String string = StringUtils.toString(this.byteBuffer, this.position, len, encoding);
            return string;
        }
        finally {
            this.position += len + 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String readString(String encoding, int expectedLength) {
        if (this.position + expectedLength > this.getBufLength()) {
            throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("ByteArrayBuffer.2"));
        }
        try {
            String string = StringUtils.toString(this.byteBuffer, this.position, expectedLength, encoding);
            return string;
        }
        finally {
            this.position += expectedLength;
        }
    }

    public void setBufLength(int bufLengthToSet) {
        this.bufLength = bufLengthToSet;
    }

    public void setByteBuffer(byte[] byteBufferToSet) {
        this.byteBuffer = byteBufferToSet;
    }

    public void setPosition(int positionToSet) {
        this.position = positionToSet;
    }

    public void setWasMultiPacket(boolean flag) {
        this.wasMultiPacket = flag;
    }

    public String toString() {
        return this.dumpClampedBytes(this.getPosition());
    }

    public String toSuperString() {
        return super.toString();
    }

    public boolean wasMultiPacket() {
        return this.wasMultiPacket;
    }

    public final void writeByte(byte b) {
        this.ensureCapacity(1);
        this.byteBuffer[this.position++] = b;
    }

    public final void writeBytesNoNull(byte[] bytes) {
        int len = bytes.length;
        this.ensureCapacity(len);
        System.arraycopy(bytes, 0, this.byteBuffer, this.position, len);
        this.position += len;
    }

    public final void writeBytesNoNull(byte[] bytes, int offset, int length) {
        this.ensureCapacity(length);
        System.arraycopy(bytes, offset, this.byteBuffer, this.position, length);
        this.position += length;
    }

    public final void writeDouble(double d) {
        long l = Double.doubleToLongBits(d);
        this.writeLongLong(l);
    }

    final void writeFieldLength(long length) {
        if (length < 251L) {
            this.writeByte((byte)length);
        } else if (length < 65536L) {
            this.ensureCapacity(3);
            this.writeByte((byte)-4);
            this.writeInt((int)length);
        } else if (length < 0x1000000L) {
            this.ensureCapacity(4);
            this.writeByte((byte)-3);
            this.writeLongInt((int)length);
        } else {
            this.ensureCapacity(9);
            this.writeByte((byte)-2);
            this.writeLongLong(length);
        }
    }

    public final void writeFloat(float f) {
        this.ensureCapacity(4);
        int i = Float.floatToIntBits(f);
        byte[] b = this.byteBuffer;
        b[this.position++] = (byte)(i & 0xFF);
        b[this.position++] = (byte)(i >>> 8);
        b[this.position++] = (byte)(i >>> 16);
        b[this.position++] = (byte)(i >>> 24);
    }

    public final void writeInt(int i) {
        this.ensureCapacity(2);
        byte[] b = this.byteBuffer;
        b[this.position++] = (byte)(i & 0xFF);
        b[this.position++] = (byte)(i >>> 8);
    }

    public final void writeLenBytes(byte[] b) {
        int len = b.length;
        this.ensureCapacity(len + 9);
        this.writeFieldLength(len);
        System.arraycopy(b, 0, this.byteBuffer, this.position, len);
        this.position += len;
    }

    public final void writeLenString(String s, String encoding) {
        byte[] b = StringUtils.getBytes(s, encoding);
        int len = b.length;
        this.ensureCapacity(len + 9);
        this.writeFieldLength(len);
        System.arraycopy(b, 0, this.byteBuffer, this.position, len);
        this.position += len;
    }

    public final void writeLong(long i) {
        this.ensureCapacity(4);
        byte[] b = this.byteBuffer;
        b[this.position++] = (byte)(i & 0xFFL);
        b[this.position++] = (byte)(i >>> 8);
        b[this.position++] = (byte)(i >>> 16);
        b[this.position++] = (byte)(i >>> 24);
    }

    public final void writeLongInt(int i) {
        this.ensureCapacity(3);
        byte[] b = this.byteBuffer;
        b[this.position++] = (byte)(i & 0xFF);
        b[this.position++] = (byte)(i >>> 8);
        b[this.position++] = (byte)(i >>> 16);
    }

    public final void writeLongLong(long i) {
        this.ensureCapacity(8);
        byte[] b = this.byteBuffer;
        b[this.position++] = (byte)(i & 0xFFL);
        b[this.position++] = (byte)(i >>> 8);
        b[this.position++] = (byte)(i >>> 16);
        b[this.position++] = (byte)(i >>> 24);
        b[this.position++] = (byte)(i >>> 32);
        b[this.position++] = (byte)(i >>> 40);
        b[this.position++] = (byte)(i >>> 48);
        b[this.position++] = (byte)(i >>> 56);
    }

    final void writeString(String s) {
        this.ensureCapacity(s.length() * 3 + 1);
        this.writeStringNoNull(s);
        this.byteBuffer[this.position++] = 0;
    }

    public final void writeString(String s, String encoding) {
        this.ensureCapacity(s.length() * 3 + 1);
        this.writeStringNoNull(s, encoding);
        this.byteBuffer[this.position++] = 0;
    }

    public final void writeStringNoNull(String s) {
        int len = s.length();
        this.ensureCapacity(len * 3);
        System.arraycopy(StringUtils.getBytes(s), 0, this.byteBuffer, this.position, len);
        this.position += len;
    }

    public final void writeStringNoNull(String s, String encoding) {
        byte[] b = StringUtils.getBytes(s, encoding);
        int len = b.length;
        this.ensureCapacity(len);
        System.arraycopy(b, 0, this.byteBuffer, this.position, len);
        this.position += len;
    }
}

