/*
  Copyright (c) 2015, 2016, Oracle and/or its affiliates. All rights reserved.

  The MySQL Connector/J is licensed under the terms of the GPLv2
  <http://www.gnu.org/licenses/old-licenses/gpl-2.0.html>, like most MySQL Connectors.
  There are special exceptions to the terms and conditions of the GPLv2 as it is applied to
  this software, see the FOSS License Exception
  <http://www.mysql.com/about/legal/licensing/foss-exception.html>.

  This program is free software; you can redistribute it and/or modify it under the terms
  of the GNU General Public License as published by the Free Software Foundation; version 2
  of the License.

  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  See the GNU General Public License for more details.

  You should have received a copy of the GNU General Public License along with this
  program; if not, write to the Free Software Foundation, Inc., 51 Franklin St, Fifth
  Floor, Boston, MA 02110-1301  USA

 */

package com.mysql.cj.mysqlx.protobuf;

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: mysqlx_sql.proto

public final class MysqlxSql {
  private MysqlxSql() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
  }
  public interface StmtExecuteOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Sql.StmtExecute)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>optional string namespace = 3 [default = "sql"];</code>
     */
    boolean hasNamespace();
    /**
     * <code>optional string namespace = 3 [default = "sql"];</code>
     */
    java.lang.String getNamespace();
    /**
     * <code>optional string namespace = 3 [default = "sql"];</code>
     */
    com.google.protobuf.ByteString
        getNamespaceBytes();

    /**
     * <code>required bytes stmt = 1;</code>
     */
    boolean hasStmt();
    /**
     * <code>required bytes stmt = 1;</code>
     */
    com.google.protobuf.ByteString getStmt();

    /**
     * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
     */
    java.util.List<com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.Any> 
        getArgsList();
    /**
     * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
     */
    com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.Any getArgs(int index);
    /**
     * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
     */
    int getArgsCount();
    /**
     * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
     */
    java.util.List<? extends com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.AnyOrBuilder> 
        getArgsOrBuilderList();
    /**
     * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
     */
    com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.AnyOrBuilder getArgsOrBuilder(
        int index);

    /**
     * <code>optional bool compact_metadata = 4 [default = false];</code>
     */
    boolean hasCompactMetadata();
    /**
     * <code>optional bool compact_metadata = 4 [default = false];</code>
     */
    boolean getCompactMetadata();
  }
  /**
   * Protobuf type {@code Mysqlx.Sql.StmtExecute}
   *
   * <pre>
   * execute a statement in the given namespace
   * .. uml::
   *   client -&gt; server: StmtExecute
   *   ... zero or more Resultsets ...
   *   server --&gt; client: StmtExecuteOk
   * Notices:
   *   This message may generate a notice containing WARNINGs generated by its execution.
   *   This message may generate a notice containing INFO messages generated by its execution.
   * :param namespace: namespace of the statement to be executed
   * :param stmt: statement that shall be executed.
   * :param args: values for wildcard replacements
   * :param compact_metadata: send only type information for :protobuf:msg:`Mysqlx.Resultset::ColumnMetadata`, skipping names and others
   * :returns:
   *    * zero or one :protobuf:msg:`Mysqlx.Resultset::` followed by :protobuf:msg:`Mysqlx.Sql::StmtExecuteOk`
   * </pre>
   */
  public static final class StmtExecute extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Sql.StmtExecute)
      StmtExecuteOrBuilder {
    // Use StmtExecute.newBuilder() to construct.
    private StmtExecute(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private StmtExecute(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final StmtExecute defaultInstance;
    public static StmtExecute getDefaultInstance() {
      return defaultInstance;
    }

    public StmtExecute getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private StmtExecute(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              bitField0_ |= 0x00000002;
              stmt_ = input.readBytes();
              break;
            }
            case 18: {
              if (!((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
                args_ = new java.util.ArrayList<com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.Any>();
                mutable_bitField0_ |= 0x00000004;
              }
              args_.add(input.readMessage(com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.Any.PARSER, extensionRegistry));
              break;
            }
            case 26: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000001;
              namespace_ = bs;
              break;
            }
            case 32: {
              bitField0_ |= 0x00000004;
              compactMetadata_ = input.readBool();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
          args_ = java.util.Collections.unmodifiableList(args_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.mysqlx.protobuf.MysqlxSql.internal_static_Mysqlx_Sql_StmtExecute_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.mysqlx.protobuf.MysqlxSql.internal_static_Mysqlx_Sql_StmtExecute_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecute.class, com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecute.Builder.class);
    }

    public static com.google.protobuf.Parser<StmtExecute> PARSER =
        new com.google.protobuf.AbstractParser<StmtExecute>() {
      public StmtExecute parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new StmtExecute(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<StmtExecute> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    public static final int NAMESPACE_FIELD_NUMBER = 3;
    private java.lang.Object namespace_;
    /**
     * <code>optional string namespace = 3 [default = "sql"];</code>
     */
    public boolean hasNamespace() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional string namespace = 3 [default = "sql"];</code>
     */
    public java.lang.String getNamespace() {
      java.lang.Object ref = namespace_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          namespace_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string namespace = 3 [default = "sql"];</code>
     */
    public com.google.protobuf.ByteString
        getNamespaceBytes() {
      java.lang.Object ref = namespace_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        namespace_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int STMT_FIELD_NUMBER = 1;
    private com.google.protobuf.ByteString stmt_;
    /**
     * <code>required bytes stmt = 1;</code>
     */
    public boolean hasStmt() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>required bytes stmt = 1;</code>
     */
    public com.google.protobuf.ByteString getStmt() {
      return stmt_;
    }

    public static final int ARGS_FIELD_NUMBER = 2;
    private java.util.List<com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.Any> args_;
    /**
     * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
     */
    public java.util.List<com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.Any> getArgsList() {
      return args_;
    }
    /**
     * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
     */
    public java.util.List<? extends com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.AnyOrBuilder> 
        getArgsOrBuilderList() {
      return args_;
    }
    /**
     * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
     */
    public int getArgsCount() {
      return args_.size();
    }
    /**
     * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
     */
    public com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.Any getArgs(int index) {
      return args_.get(index);
    }
    /**
     * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
     */
    public com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.AnyOrBuilder getArgsOrBuilder(
        int index) {
      return args_.get(index);
    }

    public static final int COMPACT_METADATA_FIELD_NUMBER = 4;
    private boolean compactMetadata_;
    /**
     * <code>optional bool compact_metadata = 4 [default = false];</code>
     */
    public boolean hasCompactMetadata() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional bool compact_metadata = 4 [default = false];</code>
     */
    public boolean getCompactMetadata() {
      return compactMetadata_;
    }

    private void initFields() {
      namespace_ = "sql";
      stmt_ = com.google.protobuf.ByteString.EMPTY;
      args_ = java.util.Collections.emptyList();
      compactMetadata_ = false;
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasStmt()) {
        memoizedIsInitialized = 0;
        return false;
      }
      for (int i = 0; i < getArgsCount(); i++) {
        if (!getArgs(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeBytes(1, stmt_);
      }
      for (int i = 0; i < args_.size(); i++) {
        output.writeMessage(2, args_.get(i));
      }
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeBytes(3, getNamespaceBytes());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeBool(4, compactMetadata_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(1, stmt_);
      }
      for (int i = 0; i < args_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, args_.get(i));
      }
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(3, getNamespaceBytes());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(4, compactMetadata_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecute parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecute parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecute parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecute parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecute parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecute parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecute parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecute parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecute parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecute parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecute prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Mysqlx.Sql.StmtExecute}
     *
     * <pre>
     * execute a statement in the given namespace
     * .. uml::
     *   client -&gt; server: StmtExecute
     *   ... zero or more Resultsets ...
     *   server --&gt; client: StmtExecuteOk
     * Notices:
     *   This message may generate a notice containing WARNINGs generated by its execution.
     *   This message may generate a notice containing INFO messages generated by its execution.
     * :param namespace: namespace of the statement to be executed
     * :param stmt: statement that shall be executed.
     * :param args: values for wildcard replacements
     * :param compact_metadata: send only type information for :protobuf:msg:`Mysqlx.Resultset::ColumnMetadata`, skipping names and others
     * :returns:
     *    * zero or one :protobuf:msg:`Mysqlx.Resultset::` followed by :protobuf:msg:`Mysqlx.Sql::StmtExecuteOk`
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Sql.StmtExecute)
        com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecuteOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.mysqlx.protobuf.MysqlxSql.internal_static_Mysqlx_Sql_StmtExecute_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.mysqlx.protobuf.MysqlxSql.internal_static_Mysqlx_Sql_StmtExecute_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecute.class, com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecute.Builder.class);
      }

      // Construct using com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecute.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getArgsFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        namespace_ = "sql";
        bitField0_ = (bitField0_ & ~0x00000001);
        stmt_ = com.google.protobuf.ByteString.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000002);
        if (argsBuilder_ == null) {
          args_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
        } else {
          argsBuilder_.clear();
        }
        compactMetadata_ = false;
        bitField0_ = (bitField0_ & ~0x00000008);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.mysqlx.protobuf.MysqlxSql.internal_static_Mysqlx_Sql_StmtExecute_descriptor;
      }

      public com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecute getDefaultInstanceForType() {
        return com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecute.getDefaultInstance();
      }

      public com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecute build() {
        com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecute result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecute buildPartial() {
        com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecute result = new com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecute(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.namespace_ = namespace_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.stmt_ = stmt_;
        if (argsBuilder_ == null) {
          if (((bitField0_ & 0x00000004) == 0x00000004)) {
            args_ = java.util.Collections.unmodifiableList(args_);
            bitField0_ = (bitField0_ & ~0x00000004);
          }
          result.args_ = args_;
        } else {
          result.args_ = argsBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000004;
        }
        result.compactMetadata_ = compactMetadata_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecute) {
          return mergeFrom((com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecute)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecute other) {
        if (other == com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecute.getDefaultInstance()) return this;
        if (other.hasNamespace()) {
          bitField0_ |= 0x00000001;
          namespace_ = other.namespace_;
          onChanged();
        }
        if (other.hasStmt()) {
          setStmt(other.getStmt());
        }
        if (argsBuilder_ == null) {
          if (!other.args_.isEmpty()) {
            if (args_.isEmpty()) {
              args_ = other.args_;
              bitField0_ = (bitField0_ & ~0x00000004);
            } else {
              ensureArgsIsMutable();
              args_.addAll(other.args_);
            }
            onChanged();
          }
        } else {
          if (!other.args_.isEmpty()) {
            if (argsBuilder_.isEmpty()) {
              argsBuilder_.dispose();
              argsBuilder_ = null;
              args_ = other.args_;
              bitField0_ = (bitField0_ & ~0x00000004);
              argsBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getArgsFieldBuilder() : null;
            } else {
              argsBuilder_.addAllMessages(other.args_);
            }
          }
        }
        if (other.hasCompactMetadata()) {
          setCompactMetadata(other.getCompactMetadata());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (!hasStmt()) {
          
          return false;
        }
        for (int i = 0; i < getArgsCount(); i++) {
          if (!getArgs(i).isInitialized()) {
            
            return false;
          }
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecute parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecute) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.lang.Object namespace_ = "sql";
      /**
       * <code>optional string namespace = 3 [default = "sql"];</code>
       */
      public boolean hasNamespace() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional string namespace = 3 [default = "sql"];</code>
       */
      public java.lang.String getNamespace() {
        java.lang.Object ref = namespace_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            namespace_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string namespace = 3 [default = "sql"];</code>
       */
      public com.google.protobuf.ByteString
          getNamespaceBytes() {
        java.lang.Object ref = namespace_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          namespace_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string namespace = 3 [default = "sql"];</code>
       */
      public Builder setNamespace(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        namespace_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string namespace = 3 [default = "sql"];</code>
       */
      public Builder clearNamespace() {
        bitField0_ = (bitField0_ & ~0x00000001);
        namespace_ = getDefaultInstance().getNamespace();
        onChanged();
        return this;
      }
      /**
       * <code>optional string namespace = 3 [default = "sql"];</code>
       */
      public Builder setNamespaceBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        namespace_ = value;
        onChanged();
        return this;
      }

      private com.google.protobuf.ByteString stmt_ = com.google.protobuf.ByteString.EMPTY;
      /**
       * <code>required bytes stmt = 1;</code>
       */
      public boolean hasStmt() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>required bytes stmt = 1;</code>
       */
      public com.google.protobuf.ByteString getStmt() {
        return stmt_;
      }
      /**
       * <code>required bytes stmt = 1;</code>
       */
      public Builder setStmt(com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        stmt_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required bytes stmt = 1;</code>
       */
      public Builder clearStmt() {
        bitField0_ = (bitField0_ & ~0x00000002);
        stmt_ = getDefaultInstance().getStmt();
        onChanged();
        return this;
      }

      private java.util.List<com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.Any> args_ =
        java.util.Collections.emptyList();
      private void ensureArgsIsMutable() {
        if (!((bitField0_ & 0x00000004) == 0x00000004)) {
          args_ = new java.util.ArrayList<com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.Any>(args_);
          bitField0_ |= 0x00000004;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.Any, com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.Any.Builder, com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.AnyOrBuilder> argsBuilder_;

      /**
       * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
       */
      public java.util.List<com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.Any> getArgsList() {
        if (argsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(args_);
        } else {
          return argsBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
       */
      public int getArgsCount() {
        if (argsBuilder_ == null) {
          return args_.size();
        } else {
          return argsBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
       */
      public com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.Any getArgs(int index) {
        if (argsBuilder_ == null) {
          return args_.get(index);
        } else {
          return argsBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
       */
      public Builder setArgs(
          int index, com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.Any value) {
        if (argsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureArgsIsMutable();
          args_.set(index, value);
          onChanged();
        } else {
          argsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
       */
      public Builder setArgs(
          int index, com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.Any.Builder builderForValue) {
        if (argsBuilder_ == null) {
          ensureArgsIsMutable();
          args_.set(index, builderForValue.build());
          onChanged();
        } else {
          argsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
       */
      public Builder addArgs(com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.Any value) {
        if (argsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureArgsIsMutable();
          args_.add(value);
          onChanged();
        } else {
          argsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
       */
      public Builder addArgs(
          int index, com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.Any value) {
        if (argsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureArgsIsMutable();
          args_.add(index, value);
          onChanged();
        } else {
          argsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
       */
      public Builder addArgs(
          com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.Any.Builder builderForValue) {
        if (argsBuilder_ == null) {
          ensureArgsIsMutable();
          args_.add(builderForValue.build());
          onChanged();
        } else {
          argsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
       */
      public Builder addArgs(
          int index, com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.Any.Builder builderForValue) {
        if (argsBuilder_ == null) {
          ensureArgsIsMutable();
          args_.add(index, builderForValue.build());
          onChanged();
        } else {
          argsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
       */
      public Builder addAllArgs(
          java.lang.Iterable<? extends com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.Any> values) {
        if (argsBuilder_ == null) {
          ensureArgsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, args_);
          onChanged();
        } else {
          argsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
       */
      public Builder clearArgs() {
        if (argsBuilder_ == null) {
          args_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
        } else {
          argsBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
       */
      public Builder removeArgs(int index) {
        if (argsBuilder_ == null) {
          ensureArgsIsMutable();
          args_.remove(index);
          onChanged();
        } else {
          argsBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
       */
      public com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.Any.Builder getArgsBuilder(
          int index) {
        return getArgsFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
       */
      public com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.AnyOrBuilder getArgsOrBuilder(
          int index) {
        if (argsBuilder_ == null) {
          return args_.get(index);  } else {
          return argsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
       */
      public java.util.List<? extends com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.AnyOrBuilder> 
           getArgsOrBuilderList() {
        if (argsBuilder_ != null) {
          return argsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(args_);
        }
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
       */
      public com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.Any.Builder addArgsBuilder() {
        return getArgsFieldBuilder().addBuilder(
            com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.Any.getDefaultInstance());
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
       */
      public com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.Any.Builder addArgsBuilder(
          int index) {
        return getArgsFieldBuilder().addBuilder(
            index, com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.Any.getDefaultInstance());
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Any args = 2;</code>
       */
      public java.util.List<com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.Any.Builder> 
           getArgsBuilderList() {
        return getArgsFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.Any, com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.Any.Builder, com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.AnyOrBuilder> 
          getArgsFieldBuilder() {
        if (argsBuilder_ == null) {
          argsBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.Any, com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.Any.Builder, com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.AnyOrBuilder>(
                  args_,
                  ((bitField0_ & 0x00000004) == 0x00000004),
                  getParentForChildren(),
                  isClean());
          args_ = null;
        }
        return argsBuilder_;
      }

      private boolean compactMetadata_ ;
      /**
       * <code>optional bool compact_metadata = 4 [default = false];</code>
       */
      public boolean hasCompactMetadata() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       * <code>optional bool compact_metadata = 4 [default = false];</code>
       */
      public boolean getCompactMetadata() {
        return compactMetadata_;
      }
      /**
       * <code>optional bool compact_metadata = 4 [default = false];</code>
       */
      public Builder setCompactMetadata(boolean value) {
        bitField0_ |= 0x00000008;
        compactMetadata_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool compact_metadata = 4 [default = false];</code>
       */
      public Builder clearCompactMetadata() {
        bitField0_ = (bitField0_ & ~0x00000008);
        compactMetadata_ = false;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Sql.StmtExecute)
    }

    static {
      defaultInstance = new StmtExecute(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Sql.StmtExecute)
  }

  public interface StmtExecuteOkOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Sql.StmtExecuteOk)
      com.google.protobuf.MessageOrBuilder {
  }
  /**
   * Protobuf type {@code Mysqlx.Sql.StmtExecuteOk}
   *
   * <pre>
   * statement executed successful
   * </pre>
   */
  public static final class StmtExecuteOk extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Sql.StmtExecuteOk)
      StmtExecuteOkOrBuilder {
    // Use StmtExecuteOk.newBuilder() to construct.
    private StmtExecuteOk(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private StmtExecuteOk(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final StmtExecuteOk defaultInstance;
    public static StmtExecuteOk getDefaultInstance() {
      return defaultInstance;
    }

    public StmtExecuteOk getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private StmtExecuteOk(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.mysqlx.protobuf.MysqlxSql.internal_static_Mysqlx_Sql_StmtExecuteOk_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.mysqlx.protobuf.MysqlxSql.internal_static_Mysqlx_Sql_StmtExecuteOk_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecuteOk.class, com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecuteOk.Builder.class);
    }

    public static com.google.protobuf.Parser<StmtExecuteOk> PARSER =
        new com.google.protobuf.AbstractParser<StmtExecuteOk>() {
      public StmtExecuteOk parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new StmtExecuteOk(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<StmtExecuteOk> getParserForType() {
      return PARSER;
    }

    private void initFields() {
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecuteOk parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecuteOk parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecuteOk parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecuteOk parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecuteOk parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecuteOk parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecuteOk parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecuteOk parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecuteOk parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecuteOk parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecuteOk prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Mysqlx.Sql.StmtExecuteOk}
     *
     * <pre>
     * statement executed successful
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Sql.StmtExecuteOk)
        com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecuteOkOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.mysqlx.protobuf.MysqlxSql.internal_static_Mysqlx_Sql_StmtExecuteOk_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.mysqlx.protobuf.MysqlxSql.internal_static_Mysqlx_Sql_StmtExecuteOk_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecuteOk.class, com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecuteOk.Builder.class);
      }

      // Construct using com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecuteOk.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.mysqlx.protobuf.MysqlxSql.internal_static_Mysqlx_Sql_StmtExecuteOk_descriptor;
      }

      public com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecuteOk getDefaultInstanceForType() {
        return com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecuteOk.getDefaultInstance();
      }

      public com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecuteOk build() {
        com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecuteOk result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecuteOk buildPartial() {
        com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecuteOk result = new com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecuteOk(this);
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecuteOk) {
          return mergeFrom((com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecuteOk)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecuteOk other) {
        if (other == com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecuteOk.getDefaultInstance()) return this;
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecuteOk parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.mysql.cj.mysqlx.protobuf.MysqlxSql.StmtExecuteOk) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Sql.StmtExecuteOk)
    }

    static {
      defaultInstance = new StmtExecuteOk(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Sql.StmtExecuteOk)
  }

  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Sql_StmtExecute_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Sql_StmtExecute_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Sql_StmtExecuteOk_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Sql_StmtExecuteOk_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n\020mysqlx_sql.proto\022\nMysqlx.Sql\032\026mysqlx_d" +
      "atatypes.proto\"y\n\013StmtExecute\022\026\n\tnamespa" +
      "ce\030\003 \001(\t:\003sql\022\014\n\004stmt\030\001 \002(\014\022#\n\004args\030\002 \003(" +
      "\0132\025.Mysqlx.Datatypes.Any\022\037\n\020compact_meta" +
      "data\030\004 \001(\010:\005false\"\017\n\rStmtExecuteOkB\036\n\034co" +
      "m.mysql.cj.mysqlx.protobuf"
    };
    com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner assigner =
        new com.google.protobuf.Descriptors.FileDescriptor.    InternalDescriptorAssigner() {
          public com.google.protobuf.ExtensionRegistry assignDescriptors(
              com.google.protobuf.Descriptors.FileDescriptor root) {
            descriptor = root;
            return null;
          }
        };
    com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
          com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.getDescriptor(),
        }, assigner);
    internal_static_Mysqlx_Sql_StmtExecute_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_Mysqlx_Sql_StmtExecute_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Sql_StmtExecute_descriptor,
        new java.lang.String[] { "Namespace", "Stmt", "Args", "CompactMetadata", });
    internal_static_Mysqlx_Sql_StmtExecuteOk_descriptor =
      getDescriptor().getMessageTypes().get(1);
    internal_static_Mysqlx_Sql_StmtExecuteOk_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Sql_StmtExecuteOk_descriptor,
        new java.lang.String[] { });
    com.mysql.cj.mysqlx.protobuf.MysqlxDatatypes.getDescriptor();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
