/*
  Copyright (c) 2015, 2016, Oracle and/or its affiliates. All rights reserved.

  The MySQL Connector/J is licensed under the terms of the GPLv2
  <http://www.gnu.org/licenses/old-licenses/gpl-2.0.html>, like most MySQL Connectors.
  There are special exceptions to the terms and conditions of the GPLv2 as it is applied to
  this software, see the FOSS License Exception
  <http://www.mysql.com/about/legal/licensing/foss-exception.html>.

  This program is free software; you can redistribute it and/or modify it under the terms
  of the GNU General Public License as published by the Free Software Foundation; version 2
  of the License.

  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  See the GNU General Public License for more details.

  You should have received a copy of the GNU General Public License along with this
  program; if not, write to the Free Software Foundation, Inc., 51 Franklin St, Fifth
  Floor, Boston, MA 02110-1301  USA

 */

package com.mysql.cj.mysqlx.protobuf;

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: mysqlx_session.proto

public final class MysqlxSession {
  private MysqlxSession() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
  }
  public interface AuthenticateStartOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Session.AuthenticateStart)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>required string mech_name = 1;</code>
     */
    boolean hasMechName();
    /**
     * <code>required string mech_name = 1;</code>
     */
    java.lang.String getMechName();
    /**
     * <code>required string mech_name = 1;</code>
     */
    com.google.protobuf.ByteString
        getMechNameBytes();

    /**
     * <code>optional bytes auth_data = 2;</code>
     */
    boolean hasAuthData();
    /**
     * <code>optional bytes auth_data = 2;</code>
     */
    com.google.protobuf.ByteString getAuthData();

    /**
     * <code>optional bytes initial_response = 3;</code>
     */
    boolean hasInitialResponse();
    /**
     * <code>optional bytes initial_response = 3;</code>
     */
    com.google.protobuf.ByteString getInitialResponse();
  }
  /**
   * Protobuf type {@code Mysqlx.Session.AuthenticateStart}
   *
   * <pre>
   * the initial message send from the client to the server to start the
   * authentication proccess
   * :param mech_name: authentication mechanism name
   * :param auth_data: authentication data
   * :param initial_response: initial response
   * :Returns: :protobuf:msg:`Mysqlx.Session::AuthenticateContinue`
   * </pre>
   */
  public static final class AuthenticateStart extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Session.AuthenticateStart)
      AuthenticateStartOrBuilder {
    // Use AuthenticateStart.newBuilder() to construct.
    private AuthenticateStart(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private AuthenticateStart(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final AuthenticateStart defaultInstance;
    public static AuthenticateStart getDefaultInstance() {
      return defaultInstance;
    }

    public AuthenticateStart getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private AuthenticateStart(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              com.google.protobuf.ByteString bs = input.readBytes();
              bitField0_ |= 0x00000001;
              mechName_ = bs;
              break;
            }
            case 18: {
              bitField0_ |= 0x00000002;
              authData_ = input.readBytes();
              break;
            }
            case 26: {
              bitField0_ |= 0x00000004;
              initialResponse_ = input.readBytes();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.mysqlx.protobuf.MysqlxSession.internal_static_Mysqlx_Session_AuthenticateStart_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.mysqlx.protobuf.MysqlxSession.internal_static_Mysqlx_Session_AuthenticateStart_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateStart.class, com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateStart.Builder.class);
    }

    public static com.google.protobuf.Parser<AuthenticateStart> PARSER =
        new com.google.protobuf.AbstractParser<AuthenticateStart>() {
      public AuthenticateStart parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new AuthenticateStart(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<AuthenticateStart> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    public static final int MECH_NAME_FIELD_NUMBER = 1;
    private java.lang.Object mechName_;
    /**
     * <code>required string mech_name = 1;</code>
     */
    public boolean hasMechName() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>required string mech_name = 1;</code>
     */
    public java.lang.String getMechName() {
      java.lang.Object ref = mechName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          mechName_ = s;
        }
        return s;
      }
    }
    /**
     * <code>required string mech_name = 1;</code>
     */
    public com.google.protobuf.ByteString
        getMechNameBytes() {
      java.lang.Object ref = mechName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        mechName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int AUTH_DATA_FIELD_NUMBER = 2;
    private com.google.protobuf.ByteString authData_;
    /**
     * <code>optional bytes auth_data = 2;</code>
     */
    public boolean hasAuthData() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional bytes auth_data = 2;</code>
     */
    public com.google.protobuf.ByteString getAuthData() {
      return authData_;
    }

    public static final int INITIAL_RESPONSE_FIELD_NUMBER = 3;
    private com.google.protobuf.ByteString initialResponse_;
    /**
     * <code>optional bytes initial_response = 3;</code>
     */
    public boolean hasInitialResponse() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional bytes initial_response = 3;</code>
     */
    public com.google.protobuf.ByteString getInitialResponse() {
      return initialResponse_;
    }

    private void initFields() {
      mechName_ = "";
      authData_ = com.google.protobuf.ByteString.EMPTY;
      initialResponse_ = com.google.protobuf.ByteString.EMPTY;
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasMechName()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeBytes(1, getMechNameBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeBytes(2, authData_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeBytes(3, initialResponse_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(1, getMechNameBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(2, authData_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(3, initialResponse_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateStart parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateStart parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateStart parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateStart parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateStart parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateStart parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateStart parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateStart parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateStart parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateStart parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateStart prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Mysqlx.Session.AuthenticateStart}
     *
     * <pre>
     * the initial message send from the client to the server to start the
     * authentication proccess
     * :param mech_name: authentication mechanism name
     * :param auth_data: authentication data
     * :param initial_response: initial response
     * :Returns: :protobuf:msg:`Mysqlx.Session::AuthenticateContinue`
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Session.AuthenticateStart)
        com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateStartOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.mysqlx.protobuf.MysqlxSession.internal_static_Mysqlx_Session_AuthenticateStart_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.mysqlx.protobuf.MysqlxSession.internal_static_Mysqlx_Session_AuthenticateStart_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateStart.class, com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateStart.Builder.class);
      }

      // Construct using com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateStart.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        mechName_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        authData_ = com.google.protobuf.ByteString.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000002);
        initialResponse_ = com.google.protobuf.ByteString.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.mysqlx.protobuf.MysqlxSession.internal_static_Mysqlx_Session_AuthenticateStart_descriptor;
      }

      public com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateStart getDefaultInstanceForType() {
        return com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateStart.getDefaultInstance();
      }

      public com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateStart build() {
        com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateStart result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateStart buildPartial() {
        com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateStart result = new com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateStart(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.mechName_ = mechName_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.authData_ = authData_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.initialResponse_ = initialResponse_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateStart) {
          return mergeFrom((com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateStart)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateStart other) {
        if (other == com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateStart.getDefaultInstance()) return this;
        if (other.hasMechName()) {
          bitField0_ |= 0x00000001;
          mechName_ = other.mechName_;
          onChanged();
        }
        if (other.hasAuthData()) {
          setAuthData(other.getAuthData());
        }
        if (other.hasInitialResponse()) {
          setInitialResponse(other.getInitialResponse());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (!hasMechName()) {
          
          return false;
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateStart parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateStart) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private java.lang.Object mechName_ = "";
      /**
       * <code>required string mech_name = 1;</code>
       */
      public boolean hasMechName() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required string mech_name = 1;</code>
       */
      public java.lang.String getMechName() {
        java.lang.Object ref = mechName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            mechName_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>required string mech_name = 1;</code>
       */
      public com.google.protobuf.ByteString
          getMechNameBytes() {
        java.lang.Object ref = mechName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          mechName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>required string mech_name = 1;</code>
       */
      public Builder setMechName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        mechName_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required string mech_name = 1;</code>
       */
      public Builder clearMechName() {
        bitField0_ = (bitField0_ & ~0x00000001);
        mechName_ = getDefaultInstance().getMechName();
        onChanged();
        return this;
      }
      /**
       * <code>required string mech_name = 1;</code>
       */
      public Builder setMechNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        mechName_ = value;
        onChanged();
        return this;
      }

      private com.google.protobuf.ByteString authData_ = com.google.protobuf.ByteString.EMPTY;
      /**
       * <code>optional bytes auth_data = 2;</code>
       */
      public boolean hasAuthData() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional bytes auth_data = 2;</code>
       */
      public com.google.protobuf.ByteString getAuthData() {
        return authData_;
      }
      /**
       * <code>optional bytes auth_data = 2;</code>
       */
      public Builder setAuthData(com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        authData_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bytes auth_data = 2;</code>
       */
      public Builder clearAuthData() {
        bitField0_ = (bitField0_ & ~0x00000002);
        authData_ = getDefaultInstance().getAuthData();
        onChanged();
        return this;
      }

      private com.google.protobuf.ByteString initialResponse_ = com.google.protobuf.ByteString.EMPTY;
      /**
       * <code>optional bytes initial_response = 3;</code>
       */
      public boolean hasInitialResponse() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>optional bytes initial_response = 3;</code>
       */
      public com.google.protobuf.ByteString getInitialResponse() {
        return initialResponse_;
      }
      /**
       * <code>optional bytes initial_response = 3;</code>
       */
      public Builder setInitialResponse(com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000004;
        initialResponse_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bytes initial_response = 3;</code>
       */
      public Builder clearInitialResponse() {
        bitField0_ = (bitField0_ & ~0x00000004);
        initialResponse_ = getDefaultInstance().getInitialResponse();
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Session.AuthenticateStart)
    }

    static {
      defaultInstance = new AuthenticateStart(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Session.AuthenticateStart)
  }

  public interface AuthenticateContinueOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Session.AuthenticateContinue)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>required bytes auth_data = 1;</code>
     */
    boolean hasAuthData();
    /**
     * <code>required bytes auth_data = 1;</code>
     */
    com.google.protobuf.ByteString getAuthData();
  }
  /**
   * Protobuf type {@code Mysqlx.Session.AuthenticateContinue}
   *
   * <pre>
   * send by client or server after a :protobuf:msg:`Mysqlx.Session::AuthenticateStart` to
   * exchange more auth data
   * :param auth_data: authentication data
   * :Returns: :protobuf:msg:`Mysqlx.Session::AuthenticateContinue`
   * </pre>
   */
  public static final class AuthenticateContinue extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Session.AuthenticateContinue)
      AuthenticateContinueOrBuilder {
    // Use AuthenticateContinue.newBuilder() to construct.
    private AuthenticateContinue(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private AuthenticateContinue(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final AuthenticateContinue defaultInstance;
    public static AuthenticateContinue getDefaultInstance() {
      return defaultInstance;
    }

    public AuthenticateContinue getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private AuthenticateContinue(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              bitField0_ |= 0x00000001;
              authData_ = input.readBytes();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.mysqlx.protobuf.MysqlxSession.internal_static_Mysqlx_Session_AuthenticateContinue_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.mysqlx.protobuf.MysqlxSession.internal_static_Mysqlx_Session_AuthenticateContinue_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateContinue.class, com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateContinue.Builder.class);
    }

    public static com.google.protobuf.Parser<AuthenticateContinue> PARSER =
        new com.google.protobuf.AbstractParser<AuthenticateContinue>() {
      public AuthenticateContinue parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new AuthenticateContinue(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<AuthenticateContinue> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    public static final int AUTH_DATA_FIELD_NUMBER = 1;
    private com.google.protobuf.ByteString authData_;
    /**
     * <code>required bytes auth_data = 1;</code>
     */
    public boolean hasAuthData() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>required bytes auth_data = 1;</code>
     */
    public com.google.protobuf.ByteString getAuthData() {
      return authData_;
    }

    private void initFields() {
      authData_ = com.google.protobuf.ByteString.EMPTY;
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasAuthData()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeBytes(1, authData_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(1, authData_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateContinue parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateContinue parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateContinue parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateContinue parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateContinue parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateContinue parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateContinue parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateContinue parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateContinue parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateContinue parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateContinue prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Mysqlx.Session.AuthenticateContinue}
     *
     * <pre>
     * send by client or server after a :protobuf:msg:`Mysqlx.Session::AuthenticateStart` to
     * exchange more auth data
     * :param auth_data: authentication data
     * :Returns: :protobuf:msg:`Mysqlx.Session::AuthenticateContinue`
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Session.AuthenticateContinue)
        com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateContinueOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.mysqlx.protobuf.MysqlxSession.internal_static_Mysqlx_Session_AuthenticateContinue_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.mysqlx.protobuf.MysqlxSession.internal_static_Mysqlx_Session_AuthenticateContinue_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateContinue.class, com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateContinue.Builder.class);
      }

      // Construct using com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateContinue.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        authData_ = com.google.protobuf.ByteString.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.mysqlx.protobuf.MysqlxSession.internal_static_Mysqlx_Session_AuthenticateContinue_descriptor;
      }

      public com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateContinue getDefaultInstanceForType() {
        return com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateContinue.getDefaultInstance();
      }

      public com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateContinue build() {
        com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateContinue result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateContinue buildPartial() {
        com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateContinue result = new com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateContinue(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.authData_ = authData_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateContinue) {
          return mergeFrom((com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateContinue)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateContinue other) {
        if (other == com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateContinue.getDefaultInstance()) return this;
        if (other.hasAuthData()) {
          setAuthData(other.getAuthData());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (!hasAuthData()) {
          
          return false;
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateContinue parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateContinue) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private com.google.protobuf.ByteString authData_ = com.google.protobuf.ByteString.EMPTY;
      /**
       * <code>required bytes auth_data = 1;</code>
       */
      public boolean hasAuthData() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required bytes auth_data = 1;</code>
       */
      public com.google.protobuf.ByteString getAuthData() {
        return authData_;
      }
      /**
       * <code>required bytes auth_data = 1;</code>
       */
      public Builder setAuthData(com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        authData_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required bytes auth_data = 1;</code>
       */
      public Builder clearAuthData() {
        bitField0_ = (bitField0_ & ~0x00000001);
        authData_ = getDefaultInstance().getAuthData();
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Session.AuthenticateContinue)
    }

    static {
      defaultInstance = new AuthenticateContinue(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Session.AuthenticateContinue)
  }

  public interface AuthenticateOkOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Session.AuthenticateOk)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>optional bytes auth_data = 1;</code>
     */
    boolean hasAuthData();
    /**
     * <code>optional bytes auth_data = 1;</code>
     */
    com.google.protobuf.ByteString getAuthData();
  }
  /**
   * Protobuf type {@code Mysqlx.Session.AuthenticateOk}
   *
   * <pre>
   * sent by the server after successful authentication
   * :param auth_data: authentication data
   * </pre>
   */
  public static final class AuthenticateOk extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Session.AuthenticateOk)
      AuthenticateOkOrBuilder {
    // Use AuthenticateOk.newBuilder() to construct.
    private AuthenticateOk(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private AuthenticateOk(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final AuthenticateOk defaultInstance;
    public static AuthenticateOk getDefaultInstance() {
      return defaultInstance;
    }

    public AuthenticateOk getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private AuthenticateOk(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              bitField0_ |= 0x00000001;
              authData_ = input.readBytes();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.mysqlx.protobuf.MysqlxSession.internal_static_Mysqlx_Session_AuthenticateOk_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.mysqlx.protobuf.MysqlxSession.internal_static_Mysqlx_Session_AuthenticateOk_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateOk.class, com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateOk.Builder.class);
    }

    public static com.google.protobuf.Parser<AuthenticateOk> PARSER =
        new com.google.protobuf.AbstractParser<AuthenticateOk>() {
      public AuthenticateOk parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new AuthenticateOk(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<AuthenticateOk> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    public static final int AUTH_DATA_FIELD_NUMBER = 1;
    private com.google.protobuf.ByteString authData_;
    /**
     * <code>optional bytes auth_data = 1;</code>
     */
    public boolean hasAuthData() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>optional bytes auth_data = 1;</code>
     */
    public com.google.protobuf.ByteString getAuthData() {
      return authData_;
    }

    private void initFields() {
      authData_ = com.google.protobuf.ByteString.EMPTY;
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeBytes(1, authData_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(1, authData_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateOk parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateOk parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateOk parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateOk parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateOk parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateOk parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateOk parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateOk parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateOk parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateOk parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateOk prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Mysqlx.Session.AuthenticateOk}
     *
     * <pre>
     * sent by the server after successful authentication
     * :param auth_data: authentication data
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Session.AuthenticateOk)
        com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateOkOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.mysqlx.protobuf.MysqlxSession.internal_static_Mysqlx_Session_AuthenticateOk_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.mysqlx.protobuf.MysqlxSession.internal_static_Mysqlx_Session_AuthenticateOk_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateOk.class, com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateOk.Builder.class);
      }

      // Construct using com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateOk.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        authData_ = com.google.protobuf.ByteString.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.mysqlx.protobuf.MysqlxSession.internal_static_Mysqlx_Session_AuthenticateOk_descriptor;
      }

      public com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateOk getDefaultInstanceForType() {
        return com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateOk.getDefaultInstance();
      }

      public com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateOk build() {
        com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateOk result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateOk buildPartial() {
        com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateOk result = new com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateOk(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.authData_ = authData_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateOk) {
          return mergeFrom((com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateOk)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateOk other) {
        if (other == com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateOk.getDefaultInstance()) return this;
        if (other.hasAuthData()) {
          setAuthData(other.getAuthData());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateOk parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.mysql.cj.mysqlx.protobuf.MysqlxSession.AuthenticateOk) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      private com.google.protobuf.ByteString authData_ = com.google.protobuf.ByteString.EMPTY;
      /**
       * <code>optional bytes auth_data = 1;</code>
       */
      public boolean hasAuthData() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>optional bytes auth_data = 1;</code>
       */
      public com.google.protobuf.ByteString getAuthData() {
        return authData_;
      }
      /**
       * <code>optional bytes auth_data = 1;</code>
       */
      public Builder setAuthData(com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        authData_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional bytes auth_data = 1;</code>
       */
      public Builder clearAuthData() {
        bitField0_ = (bitField0_ & ~0x00000001);
        authData_ = getDefaultInstance().getAuthData();
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Session.AuthenticateOk)
    }

    static {
      defaultInstance = new AuthenticateOk(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Session.AuthenticateOk)
  }

  public interface ResetOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Session.Reset)
      com.google.protobuf.MessageOrBuilder {
  }
  /**
   * Protobuf type {@code Mysqlx.Session.Reset}
   *
   * <pre>
   * reset the current session
   * :Returns: :protobuf:msg:`Mysqlx::Ok`
   * </pre>
   */
  public static final class Reset extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Session.Reset)
      ResetOrBuilder {
    // Use Reset.newBuilder() to construct.
    private Reset(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private Reset(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final Reset defaultInstance;
    public static Reset getDefaultInstance() {
      return defaultInstance;
    }

    public Reset getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private Reset(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.mysqlx.protobuf.MysqlxSession.internal_static_Mysqlx_Session_Reset_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.mysqlx.protobuf.MysqlxSession.internal_static_Mysqlx_Session_Reset_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.mysqlx.protobuf.MysqlxSession.Reset.class, com.mysql.cj.mysqlx.protobuf.MysqlxSession.Reset.Builder.class);
    }

    public static com.google.protobuf.Parser<Reset> PARSER =
        new com.google.protobuf.AbstractParser<Reset>() {
      public Reset parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Reset(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<Reset> getParserForType() {
      return PARSER;
    }

    private void initFields() {
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static com.mysql.cj.mysqlx.protobuf.MysqlxSession.Reset parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSession.Reset parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSession.Reset parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSession.Reset parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSession.Reset parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSession.Reset parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSession.Reset parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSession.Reset parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSession.Reset parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSession.Reset parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(com.mysql.cj.mysqlx.protobuf.MysqlxSession.Reset prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Mysqlx.Session.Reset}
     *
     * <pre>
     * reset the current session
     * :Returns: :protobuf:msg:`Mysqlx::Ok`
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Session.Reset)
        com.mysql.cj.mysqlx.protobuf.MysqlxSession.ResetOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.mysqlx.protobuf.MysqlxSession.internal_static_Mysqlx_Session_Reset_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.mysqlx.protobuf.MysqlxSession.internal_static_Mysqlx_Session_Reset_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.mysqlx.protobuf.MysqlxSession.Reset.class, com.mysql.cj.mysqlx.protobuf.MysqlxSession.Reset.Builder.class);
      }

      // Construct using com.mysql.cj.mysqlx.protobuf.MysqlxSession.Reset.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.mysqlx.protobuf.MysqlxSession.internal_static_Mysqlx_Session_Reset_descriptor;
      }

      public com.mysql.cj.mysqlx.protobuf.MysqlxSession.Reset getDefaultInstanceForType() {
        return com.mysql.cj.mysqlx.protobuf.MysqlxSession.Reset.getDefaultInstance();
      }

      public com.mysql.cj.mysqlx.protobuf.MysqlxSession.Reset build() {
        com.mysql.cj.mysqlx.protobuf.MysqlxSession.Reset result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public com.mysql.cj.mysqlx.protobuf.MysqlxSession.Reset buildPartial() {
        com.mysql.cj.mysqlx.protobuf.MysqlxSession.Reset result = new com.mysql.cj.mysqlx.protobuf.MysqlxSession.Reset(this);
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.mysqlx.protobuf.MysqlxSession.Reset) {
          return mergeFrom((com.mysql.cj.mysqlx.protobuf.MysqlxSession.Reset)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.mysqlx.protobuf.MysqlxSession.Reset other) {
        if (other == com.mysql.cj.mysqlx.protobuf.MysqlxSession.Reset.getDefaultInstance()) return this;
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.mysql.cj.mysqlx.protobuf.MysqlxSession.Reset parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.mysql.cj.mysqlx.protobuf.MysqlxSession.Reset) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Session.Reset)
    }

    static {
      defaultInstance = new Reset(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Session.Reset)
  }

  public interface CloseOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Session.Close)
      com.google.protobuf.MessageOrBuilder {
  }
  /**
   * Protobuf type {@code Mysqlx.Session.Close}
   *
   * <pre>
   * close the current session
   * :Returns: :protobuf:msg:`Mysqlx::Ok`
   * </pre>
   */
  public static final class Close extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Session.Close)
      CloseOrBuilder {
    // Use Close.newBuilder() to construct.
    private Close(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private Close(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final Close defaultInstance;
    public static Close getDefaultInstance() {
      return defaultInstance;
    }

    public Close getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private Close(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.mysqlx.protobuf.MysqlxSession.internal_static_Mysqlx_Session_Close_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.mysqlx.protobuf.MysqlxSession.internal_static_Mysqlx_Session_Close_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.mysqlx.protobuf.MysqlxSession.Close.class, com.mysql.cj.mysqlx.protobuf.MysqlxSession.Close.Builder.class);
    }

    public static com.google.protobuf.Parser<Close> PARSER =
        new com.google.protobuf.AbstractParser<Close>() {
      public Close parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Close(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<Close> getParserForType() {
      return PARSER;
    }

    private void initFields() {
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static com.mysql.cj.mysqlx.protobuf.MysqlxSession.Close parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSession.Close parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSession.Close parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSession.Close parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSession.Close parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSession.Close parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSession.Close parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSession.Close parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSession.Close parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static com.mysql.cj.mysqlx.protobuf.MysqlxSession.Close parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(com.mysql.cj.mysqlx.protobuf.MysqlxSession.Close prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Mysqlx.Session.Close}
     *
     * <pre>
     * close the current session
     * :Returns: :protobuf:msg:`Mysqlx::Ok`
     * </pre>
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Session.Close)
        com.mysql.cj.mysqlx.protobuf.MysqlxSession.CloseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.mysqlx.protobuf.MysqlxSession.internal_static_Mysqlx_Session_Close_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.mysqlx.protobuf.MysqlxSession.internal_static_Mysqlx_Session_Close_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.mysqlx.protobuf.MysqlxSession.Close.class, com.mysql.cj.mysqlx.protobuf.MysqlxSession.Close.Builder.class);
      }

      // Construct using com.mysql.cj.mysqlx.protobuf.MysqlxSession.Close.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.mysqlx.protobuf.MysqlxSession.internal_static_Mysqlx_Session_Close_descriptor;
      }

      public com.mysql.cj.mysqlx.protobuf.MysqlxSession.Close getDefaultInstanceForType() {
        return com.mysql.cj.mysqlx.protobuf.MysqlxSession.Close.getDefaultInstance();
      }

      public com.mysql.cj.mysqlx.protobuf.MysqlxSession.Close build() {
        com.mysql.cj.mysqlx.protobuf.MysqlxSession.Close result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public com.mysql.cj.mysqlx.protobuf.MysqlxSession.Close buildPartial() {
        com.mysql.cj.mysqlx.protobuf.MysqlxSession.Close result = new com.mysql.cj.mysqlx.protobuf.MysqlxSession.Close(this);
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.mysqlx.protobuf.MysqlxSession.Close) {
          return mergeFrom((com.mysql.cj.mysqlx.protobuf.MysqlxSession.Close)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.mysqlx.protobuf.MysqlxSession.Close other) {
        if (other == com.mysql.cj.mysqlx.protobuf.MysqlxSession.Close.getDefaultInstance()) return this;
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.mysql.cj.mysqlx.protobuf.MysqlxSession.Close parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (com.mysql.cj.mysqlx.protobuf.MysqlxSession.Close) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Session.Close)
    }

    static {
      defaultInstance = new Close(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Session.Close)
  }

  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Session_AuthenticateStart_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Session_AuthenticateStart_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Session_AuthenticateContinue_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Session_AuthenticateContinue_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Session_AuthenticateOk_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Session_AuthenticateOk_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Session_Reset_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Session_Reset_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Session_Close_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Session_Close_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n\024mysqlx_session.proto\022\016Mysqlx.Session\"S" +
      "\n\021AuthenticateStart\022\021\n\tmech_name\030\001 \002(\t\022\021" +
      "\n\tauth_data\030\002 \001(\014\022\030\n\020initial_response\030\003 " +
      "\001(\014\")\n\024AuthenticateContinue\022\021\n\tauth_data" +
      "\030\001 \002(\014\"#\n\016AuthenticateOk\022\021\n\tauth_data\030\001 " +
      "\001(\014\"\007\n\005Reset\"\007\n\005CloseB\036\n\034com.mysql.cj.my" +
      "sqlx.protobuf"
    };
    com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner assigner =
        new com.google.protobuf.Descriptors.FileDescriptor.    InternalDescriptorAssigner() {
          public com.google.protobuf.ExtensionRegistry assignDescriptors(
              com.google.protobuf.Descriptors.FileDescriptor root) {
            descriptor = root;
            return null;
          }
        };
    com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
        }, assigner);
    internal_static_Mysqlx_Session_AuthenticateStart_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_Mysqlx_Session_AuthenticateStart_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Session_AuthenticateStart_descriptor,
        new java.lang.String[] { "MechName", "AuthData", "InitialResponse", });
    internal_static_Mysqlx_Session_AuthenticateContinue_descriptor =
      getDescriptor().getMessageTypes().get(1);
    internal_static_Mysqlx_Session_AuthenticateContinue_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Session_AuthenticateContinue_descriptor,
        new java.lang.String[] { "AuthData", });
    internal_static_Mysqlx_Session_AuthenticateOk_descriptor =
      getDescriptor().getMessageTypes().get(2);
    internal_static_Mysqlx_Session_AuthenticateOk_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Session_AuthenticateOk_descriptor,
        new java.lang.String[] { "AuthData", });
    internal_static_Mysqlx_Session_Reset_descriptor =
      getDescriptor().getMessageTypes().get(3);
    internal_static_Mysqlx_Session_Reset_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Session_Reset_descriptor,
        new java.lang.String[] { });
    internal_static_Mysqlx_Session_Close_descriptor =
      getDescriptor().getMessageTypes().get(4);
    internal_static_Mysqlx_Session_Close_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Session_Close_descriptor,
        new java.lang.String[] { });
  }

  // @@protoc_insertion_point(outer_class_scope)
}
