/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.pseudoserver;

import com.meterware.pseudoserver.HttpRequestStream;
import com.meterware.pseudoserver.HttpResponseStream;
import com.meterware.pseudoserver.PseudoServlet;
import com.meterware.pseudoserver.UnknownMethodException;
import com.meterware.pseudoserver.WebResource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;

public class PseudoServer {
    private ArrayList _classpathDirs = new ArrayList();
    private Hashtable _resources = new Hashtable();
    private boolean _active = true;
    private ServerSocket _serverSocket;

    public PseudoServer() {
        Thread t = new Thread(){

            public void run() {
                while (PseudoServer.this._active) {
                    try {
                        PseudoServer.this.handleConnection();
                        Thread.sleep(50L);
                    }
                    catch (InterruptedIOException e) {
                        PseudoServer.this._active = false;
                    }
                    catch (IOException e) {
                        System.out.println("Error in pseudo server: " + e);
                        e.printStackTrace();
                    }
                    catch (InterruptedException e) {
                        System.out.println("Interrupted. Shutting down");
                        PseudoServer.this._active = false;
                    }
                }
                try {
                    if (PseudoServer.this._serverSocket != null) {
                        PseudoServer.this._serverSocket.close();
                    }
                    PseudoServer.this._serverSocket = null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        t.start();
    }

    public void shutDown() {
        this._active = false;
    }

    public int getConnectedPort() throws IOException {
        return this.getServerSocket().getLocalPort();
    }

    public void setResource(String name, String value) {
        this.setResource(name, value, "text/html");
    }

    public void setResource(String name, PseudoServlet servlet) {
        this._resources.put(this.asResourceName(name), servlet);
    }

    public void setResource(String name, String value, String contentType) {
        this._resources.put(this.asResourceName(name), new WebResource(value, contentType));
    }

    public void setResource(String name, byte[] value, String contentType) {
        this._resources.put(this.asResourceName(name), new WebResource(value, contentType));
    }

    public void setErrorResource(String name, int errorCode, String errorMessage) {
        this._resources.put(this.asResourceName(name), new WebResource(errorMessage, errorCode));
    }

    public void setSendCharacterSet(String name, boolean enabled) {
        WebResource resource = (WebResource)this._resources.get(this.asResourceName(name));
        if (resource == null) {
            throw new IllegalArgumentException("No defined resource " + name);
        }
        resource.setSendCharacterSet(enabled);
    }

    public void setCharacterSet(String name, String characterSet) {
        WebResource resource = (WebResource)this._resources.get(this.asResourceName(name));
        if (resource == null) {
            resource = new WebResource("");
            this._resources.put(this.asResourceName(name), resource);
        }
        resource.setCharacterSet(characterSet);
    }

    public void addResourceHeader(String name, String header) {
        WebResource resource = (WebResource)this._resources.get(this.asResourceName(name));
        if (resource == null) {
            resource = new WebResource("");
            this._resources.put(this.asResourceName(name), resource);
        }
        resource.addHeader(header);
    }

    public void mapToClasspath(String directory) {
        this._classpathDirs.add(directory);
    }

    private String asResourceName(String rawName) {
        if (rawName.startsWith("/")) {
            return PseudoServer.escape(rawName);
        }
        return PseudoServer.escape("/" + rawName);
    }

    private static String escape(String urlString) {
        if (urlString.indexOf(32) < 0) {
            return urlString;
        }
        StringBuffer sb = new StringBuffer();
        int start = 0;
        while (true) {
            int index;
            if ((index = urlString.indexOf(32, start)) < 0) break;
            sb.append(urlString.substring(start, index)).append("%20");
            start = index + 1;
        }
        sb.append(urlString.substring(start));
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleConnection() throws IOException {
        Socket socket = this.getServerSocket().accept();
        socket.setSoTimeout(1000);
        socket.setTcpNoDelay(true);
        HttpRequestStream request = new HttpRequestStream(socket.getInputStream());
        HttpResponseStream response = new HttpResponseStream(socket.getOutputStream());
        try {
            block11: {
                try {
                    WebResource resource = this.getResource(request);
                    if (resource == null) {
                        response.setResponse(404, "unable to find " + request.getURI());
                        break block11;
                    }
                    if (resource.getResponseCode() != 200) {
                        response.setResponse(resource.getResponseCode(), "");
                    }
                    String[] headers = resource.getHeaders();
                    int i = 0;
                    while (true) {
                        if (i >= headers.length) {
                            response.write(resource);
                            break;
                        }
                        response.addHeader(headers[i]);
                        ++i;
                    }
                }
                catch (UnknownMethodException e) {
                    response.setResponse(405, "unsupported method: " + e.getMethod());
                    Object var8_11 = null;
                    response.close();
                    socket.close();
                    return;
                }
                catch (IOException e) {
                    e.fillInStackTrace();
                    throw e;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    response.setResponse(500, t.toString());
                    Object var8_12 = null;
                    response.close();
                    socket.close();
                    return;
                }
            }
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            response.close();
            socket.close();
            throw throwable;
        }
        response.close();
        socket.close();
    }

    private WebResource getResource(HttpRequestStream request) throws IOException {
        Object resource = this._resources.get(request.getURI());
        if (request.getCommand().equals("GET") && resource instanceof WebResource) {
            return (WebResource)resource;
        }
        if (resource instanceof PseudoServlet) {
            return this.getResource((PseudoServlet)resource, request);
        }
        if (request.getURI().endsWith(".class")) {
            Iterator iterator = this._classpathDirs.iterator();
            while (iterator.hasNext()) {
                String directory = (String)iterator.next();
                if (!request.getURI().startsWith(directory)) continue;
                String resourceName = request.getURI().substring(directory.length() + 1);
                return new WebResource(this.getClass().getClassLoader().getResourceAsStream(resourceName), "application/class", 200);
            }
            return null;
        }
        if (request.getURI().endsWith(".zip") || request.getURI().endsWith(".jar")) {
            Iterator iterator = this._classpathDirs.iterator();
            while (iterator.hasNext()) {
                String directory = (String)iterator.next();
                if (!request.getURI().startsWith(directory)) continue;
                String resourceName = request.getURI().substring(directory.length() + 1);
                String classPath = System.getProperty("java.class.path");
                StringTokenizer st = new StringTokenizer(classPath, ":;,");
                while (st.hasMoreTokens()) {
                    String file = st.nextToken();
                    if (!file.endsWith(resourceName)) continue;
                    File f = new File(file);
                    return new WebResource(new FileInputStream(f), "application/zip", 200);
                }
            }
            return null;
        }
        return null;
    }

    private WebResource getResource(PseudoServlet servlet, HttpRequestStream request) throws IOException {
        servlet.init(request);
        return servlet.getResponse(request.getCommand());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServerSocket getServerSocket() throws IOException {
        PseudoServer pseudoServer = this;
        synchronized (pseudoServer) {
            if (this._serverSocket == null) {
                this._serverSocket = new ServerSocket(0);
            }
            this._serverSocket.setSoTimeout(1000);
        }
        return this._serverSocket;
    }
}

