/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.pseudoserver;

import com.meterware.pseudoserver.PseudoServer;
import com.meterware.pseudoserver.PseudoServlet;
import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.TestCase;

public class HttpUserAgentTest
extends TestCase {
    private String _hostPath;
    private PseudoServer _server;

    public HttpUserAgentTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        this._server = new PseudoServer();
        this._hostPath = "http://localhost:" + this._server.getConnectedPort();
    }

    public void tearDown() throws Exception {
        if (this._server != null) {
            this._server.shutDown();
        }
    }

    protected void defineResource(String resourceName, PseudoServlet servlet) {
        this._server.setResource(resourceName, servlet);
    }

    protected void defineResource(String resourceName, String value) {
        this._server.setResource(resourceName, value);
    }

    protected void defineResource(String resourceName, String value, int statusCode) {
        this._server.setErrorResource(resourceName, statusCode, value);
    }

    protected void defineResource(String resourceName, String value, String contentType) {
        this._server.setResource(resourceName, value, contentType);
    }

    protected void addResourceHeader(String resourceName, String header) {
        this._server.addResourceHeader(resourceName, header);
    }

    protected void setResourceCharSet(String resourceName, String setName, boolean reportCharSet) {
        this._server.setCharacterSet(resourceName, setName);
        this._server.setSendCharacterSet(resourceName, reportCharSet);
    }

    protected void defineWebPage(String pageName, String body) {
        this.defineResource(pageName + ".html", "<html><head><title>" + pageName + "</title></head>\n" + "<body>" + body + "</body></html>");
    }

    protected void mapToClasspath(String directory) {
        this._server.mapToClasspath(directory);
    }

    protected String getHostPath() {
        return this._hostPath;
    }

    protected int getHostPort() throws IOException {
        return this._server.getConnectedPort();
    }

    protected void assertEqualQueries(String query1, String query2) {
        Assert.assertEquals((Object)new QuerySpec(query1), (Object)new QuerySpec(query2));
    }

    protected void assertEquals(String comment, Object[] expected, Object[] found) {
        if (!this.equals(expected, found)) {
            Assert.fail((String)(comment + " expected: " + this.asText(expected) + " but found " + this.asText(found)));
        }
    }

    private boolean equals(Object[] first, Object[] second) {
        if (first.length != second.length) {
            return false;
        }
        int i = 0;
        while (i < first.length) {
            if (!first[i].equals(second[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void assertImplements(String comment, Object object, Class expectedClass) {
        if (object == null) {
            Assert.fail((String)(comment + " should be of class " + expectedClass.getName() + " but is null"));
        } else if (!expectedClass.isInstance(object)) {
            Assert.fail((String)(comment + " should be of class " + expectedClass.getName() + " but is " + object.getClass().getName()));
        }
    }

    protected void assertMatchingSet(String comment, Object[] expected, Enumeration found) {
        Vector foundItems = new Vector();
        while (found.hasMoreElements()) {
            foundItems.addElement(found.nextElement());
        }
        this.assertMatchingSet(comment, expected, foundItems);
    }

    private void assertMatchingSet(String comment, Object[] expected, Vector foundItems) {
        Vector<Object> expectedItems = new Vector<Object>();
        int i = 0;
        while (i < expected.length) {
            expectedItems.addElement(expected[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < expected.length) {
            if (!foundItems.contains(expected[i2])) {
                Assert.fail((String)(comment + ": expected " + this.asText(expected) + " but missing " + expected[i2]));
            } else {
                foundItems.removeElement(expected[i2]);
            }
            ++i2;
        }
        if (!foundItems.isEmpty()) {
            Assert.fail((String)(comment + ": expected " + this.asText(expected) + " but found superfluous" + foundItems.firstElement()));
        }
    }

    protected void assertMatchingSet(String comment, Object[] expected, Object[] found) {
        Vector<Object> foundItems = new Vector<Object>();
        int i = 0;
        while (i < found.length) {
            foundItems.addElement(found[i]);
            ++i;
        }
        Vector<Object> expectedItems = new Vector<Object>();
        int i2 = 0;
        while (i2 < expected.length) {
            expectedItems.addElement(expected[i2]);
            ++i2;
        }
        int i3 = 0;
        while (i3 < expected.length) {
            if (!foundItems.contains(expected[i3])) {
                Assert.fail((String)(comment + ": expected " + this.asText(expected) + " but found " + this.asText(found)));
            } else {
                foundItems.removeElement(expected[i3]);
            }
            ++i3;
        }
        int i4 = 0;
        while (i4 < found.length) {
            if (!expectedItems.contains(found[i4])) {
                Assert.fail((String)(comment + ": expected " + this.asText(expected) + " but found " + this.asText(found)));
            } else {
                expectedItems.removeElement(found[i4]);
            }
            ++i4;
        }
        if (!foundItems.isEmpty()) {
            Assert.fail((String)(comment + ": expected " + this.asText(expected) + " but found " + this.asText(found)));
        }
    }

    protected String asText(Object[] args) {
        StringBuffer sb = new StringBuffer("{");
        int i = 0;
        while (i < args.length) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append('\"').append(args[i]).append('\"');
            ++i;
        }
        sb.append("}");
        return sb.toString();
    }

    protected String asBytes(String s) {
        StringBuffer sb = new StringBuffer();
        char[] chars = s.toCharArray();
        int i = 0;
        while (i < chars.length) {
            sb.append(Integer.toHexString(chars[i])).append(" ");
            ++i;
        }
        return sb.toString();
    }

    protected void assertEquals(String comment, byte[] expected, byte[] actual) {
        if (!this.equals(expected, actual)) {
            Assert.fail((String)(comment + " expected:\n" + this.toString(expected) + ", but was:\n" + this.toString(actual)));
        }
    }

    private boolean equals(byte[] first, byte[] second) {
        if (first.length != second.length) {
            return false;
        }
        int i = 0;
        while (i < first.length) {
            if (first[i] != second[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private String toString(byte[] message) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < message.length) {
            if (i != 0 && i % 4 == 0) {
                sb.append(' ');
            }
            if (message[i] >= 0 && message[i] < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(0xFF & message[i]));
            ++i;
        }
        return sb.toString();
    }

    static class QuerySpec {
        private String _path;
        private String _fullString;
        private Vector _parameters = new Vector();

        QuerySpec(String urlString) {
            this._path = urlString.indexOf(63) < 0 ? urlString : urlString.substring(0, urlString.indexOf(63));
            this._fullString = urlString;
            StringTokenizer st = new StringTokenizer(urlString.substring(urlString.indexOf(63) + 1), "&");
            while (st.hasMoreTokens()) {
                this._parameters.addElement(st.nextToken());
            }
        }

        public String toString() {
            return this._fullString;
        }

        public boolean equals(Object o) {
            return this.getClass().equals(o.getClass()) && this.equals((QuerySpec)o);
        }

        private boolean equals(QuerySpec o) {
            if (!this._path.equals(o._path)) {
                return false;
            }
            if (this._parameters.size() != o._parameters.size()) {
                return false;
            }
            Enumeration e = o._parameters.elements();
            while (e.hasMoreElements()) {
                if (this._parameters.contains(e.nextElement())) continue;
                return false;
            }
            return true;
        }
    }
}

