/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.pseudoserver;

import com.meterware.httpunit.HttpUnitUtils;
import com.meterware.pseudoserver.UnknownMethodException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Hashtable;
import java.util.StringTokenizer;

class HttpRequestStream {
    private static final int CR = 13;
    private static final int LF = 10;
    private InputStream _stream;
    private Reader _reader;
    private String _command;
    private String _uri;
    private Hashtable _headers = new Hashtable();
    private Hashtable _parameters;
    private byte[] _requestBody;

    HttpRequestStream(InputStream stream) throws IOException {
        this._stream = new BufferedInputStream(stream);
        StringTokenizer st = new StringTokenizer(this.readHeaderLine());
        this._command = st.nextToken();
        this._uri = st.nextToken();
        String protocol = st.nextToken();
        if (!(this._command.equals("GET") || this._command.equals("POST") || this._command.equals("PUT"))) {
            throw new UnknownMethodException(this._command);
        }
        this.readHeaders();
        this.readContent();
    }

    Reader getReader() {
        return this._reader;
    }

    String getCommand() {
        return this._command;
    }

    String getURI() {
        return this._uri;
    }

    String getHeader(String name) {
        return (String)this._headers.get(name.toUpperCase());
    }

    byte[] getBody() {
        return this._requestBody;
    }

    String[] getParameter(String name) {
        if (this._parameters == null) {
            this._parameters = this.readParameters(new String(this._requestBody));
        }
        return (String[])this._parameters.get(name);
    }

    private void readContent() throws IOException {
        this._requestBody = new byte[this.getContentLength()];
        try {
            this._stream.read(this._requestBody);
            this._reader = new InputStreamReader(new ByteArrayInputStream(this._requestBody));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private int getContentLength() {
        try {
            return Integer.parseInt(this.getHeader("Content-Length"));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private void readHeaders() throws IOException {
        String lastHeader = null;
        String header = this.readHeaderLine();
        while (header.length() > 0) {
            if (header.charAt(0) <= ' ') {
                if (lastHeader == null) continue;
                this._headers.put(lastHeader, this._headers.get(lastHeader) + header.trim());
            } else {
                lastHeader = header.substring(0, header.indexOf(58)).toUpperCase();
                this._headers.put(lastHeader, header.substring(header.indexOf(58) + 1).trim());
            }
            header = this.readHeaderLine();
        }
    }

    private String readHeaderLine() throws IOException {
        StringBuffer sb = new StringBuffer();
        int b = this._stream.read();
        while (b != 13) {
            sb.append((char)b);
            b = this._stream.read();
        }
        b = this._stream.read();
        if (b != 10) {
            throw new IOException("Bad header line termination: " + b);
        }
        return sb.toString();
    }

    private Hashtable readParameters(String content) {
        Hashtable parameters = new Hashtable();
        if (content == null || content.trim().length() == 0) {
            return parameters;
        }
        StringTokenizer st = new StringTokenizer(content, "&=");
        while (st.hasMoreTokens()) {
            String name = st.nextToken();
            if (!st.hasMoreTokens()) continue;
            this.addParameter(parameters, HttpUnitUtils.decode(name), HttpUnitUtils.decode(st.nextToken()));
        }
        return parameters;
    }

    private void addParameter(Hashtable parameters, String name, String value) {
        String[] oldValues = (String[])parameters.get(name);
        if (oldValues == null) {
            parameters.put(name, new String[]{value});
        } else {
            String[] values = new String[oldValues.length + 1];
            System.arraycopy(oldValues, 0, values, 0, oldValues.length);
            values[oldValues.length] = value;
            parameters.put(name, values);
        }
    }

    static {
        CR = 13;
        LF = 10;
    }
}

