/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.HTMLElement;
import com.meterware.httpunit.HttpUnitUtils;
import com.meterware.httpunit.NodeUtils;
import com.meterware.httpunit.ParameterHolder;
import com.meterware.httpunit.WebFrame;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import java.io.IOException;
import java.net.URL;
import java.util.StringTokenizer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public abstract class WebRequestSource
extends ParameterHolder
implements HTMLElement {
    private static final String PARAM_DELIM = "&";
    private WebResponse _baseResponse;
    private String _pageFrame;
    private URL _baseURL;
    private String _destination;
    private Node _node;

    public String getID() {
        return this.getAttribute("id");
    }

    public String getName() {
        return this.getAttribute("name");
    }

    public String getTitle() {
        return this.getAttribute("title");
    }

    public String getTarget() {
        if (this.getSpecifiedTarget().length() == 0 || this.getSpecifiedTarget().equalsIgnoreCase("_self")) {
            return this._pageFrame;
        }
        if (this.getSpecifiedTarget().equalsIgnoreCase("_parent")) {
            return WebFrame.getParentFrameName(this._pageFrame);
        }
        return this.getSpecifiedTarget();
    }

    public String getPageFrame() {
        return this._pageFrame;
    }

    public String getFragmentIdentifier() {
        int hashIndex = this.getDestination().indexOf(35);
        if (hashIndex < 0) {
            return "";
        }
        return this.getDestination().substring(hashIndex + 1);
    }

    public Node getDOMSubtree() {
        return this._node.cloneNode(true);
    }

    public abstract WebRequest getRequest();

    public abstract String[] getParameterNames();

    public abstract String[] getParameterValues(String var1);

    String getRelativePage() {
        String url = this.getRelativeURL();
        if (url.startsWith("javascript:")) {
            return url;
        }
        int questionMarkIndex = url.indexOf("?");
        if (questionMarkIndex >= 1 && questionMarkIndex < url.length() - 1) {
            return url.substring(0, questionMarkIndex);
        }
        return url;
    }

    protected String getRelativeURL() {
        String result = this.trimFragment(this.getDestination());
        if (result.trim().length() == 0) {
            result = this.getBaseURL().getFile();
        }
        return result;
    }

    private String trimFragment(String href) {
        int hashIndex = href.indexOf(35);
        if (hashIndex < 0) {
            return href;
        }
        return href.substring(0, hashIndex);
    }

    WebRequestSource(WebResponse response, Node node, URL baseURL, String destination, String pageFrame) {
        if (node == null) {
            throw new IllegalArgumentException("node must not be null");
        }
        this._baseResponse = response;
        this._node = node;
        this._baseURL = baseURL;
        this._destination = destination;
        this._pageFrame = pageFrame;
    }

    protected URL getBaseURL() {
        return this._baseURL;
    }

    protected String getDestination() {
        return this._destination;
    }

    protected void setDestination(String destination) {
        this._destination = destination;
    }

    protected Node getNode() {
        return this._node;
    }

    protected final void loadDestinationParameters() {
        StringTokenizer st = new StringTokenizer(this.getParametersString(), PARAM_DELIM);
        while (st.hasMoreTokens()) {
            this.stripOneParameter(st.nextToken());
        }
    }

    protected final WebResponse submitRequest() throws IOException, SAXException {
        return this.submitRequest(this.getRequest());
    }

    protected final WebResponse submitRequest(WebRequest request) throws IOException, SAXException {
        return this.getDestination().equals("#") ? this._baseResponse : this._baseResponse.getWindow().sendRequest(request);
    }

    protected final WebResponse getBaseResponse() {
        return this._baseResponse;
    }

    protected abstract void addPresetParameter(String var1, String var2);

    String getAttribute(String name) {
        return NodeUtils.getNodeAttribute(this._node, name);
    }

    String getAttribute(String name, String defaultValue) {
        return NodeUtils.getNodeAttribute(this._node, name, defaultValue);
    }

    private String getSpecifiedTarget() {
        return this.getAttribute("target");
    }

    protected void setTargetAttribute(String value) {
        ((Element)this._node).setAttribute("target", value);
    }

    private String getParametersString() {
        String url = this.trimFragment(this.getDestination());
        if (url.trim().length() == 0) {
            url = this.getBaseURL().toExternalForm();
        }
        if (url.startsWith("javascript:")) {
            return "";
        }
        int questionMarkIndex = url.indexOf("?");
        if (questionMarkIndex >= 1 && questionMarkIndex < url.length() - 1) {
            return url.substring(questionMarkIndex + 1);
        }
        return "";
    }

    private void stripOneParameter(String param) {
        int index = param.indexOf("=");
        String value = index < 0 ? null : (index == param.length() - 1 ? this.getEmptyParameterValue() : HttpUnitUtils.decode(param.substring(index + 1)).trim());
        String name = index < 0 ? param.trim() : HttpUnitUtils.decode(param.substring(0, index)).trim();
        this.addPresetParameter(name, value);
    }

    protected abstract String getEmptyParameterValue();

    static {
        PARAM_DELIM = PARAM_DELIM;
    }
}

