/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.HttpWebResponse;
import com.meterware.httpunit.WebClient;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Dictionary;
import java.util.Enumeration;

public class WebConversation
extends WebClient {
    protected WebResponse newResponse(WebRequest request, String frameName) throws MalformedURLException, IOException {
        URLConnection connection = this.openConnection(request.getURL());
        this.sendHeaders(connection, request.getHeaderDictionary());
        request.completeRequest(connection);
        return new HttpWebResponse(this, frameName, request.getURL(), connection, this.getExceptionsThrownOnErrorStatus());
    }

    private URLConnection openConnection(URL url) throws MalformedURLException, IOException {
        URLConnection connection = url.openConnection();
        connection.setUseCaches(false);
        this.sendHeaders(connection);
        return connection;
    }

    private void sendHeaders(URLConnection connection) {
        this.sendHeaders(connection, this.getHeaderFields(connection.getURL()));
    }

    private void sendHeaders(URLConnection connection, Dictionary headers) {
        Enumeration e = headers.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            connection.setRequestProperty(key, (String)headers.get(key));
            if (!HttpUnitOptions.isLoggingHttpHeaders()) continue;
            System.out.println("Sending:: " + key + ": " + connection.getRequestProperty(key));
        }
    }

    static {
        HttpURLConnection.setFollowRedirects(false);
    }
}

