/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.HttpUnitUtils;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebResponse;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

class HttpWebResponse
extends WebResponse {
    private static final String FILE_ENCODING = System.getProperty("file.encoding");
    private int _responseCode = 200;
    private String _responseMessage = "OK";
    private Hashtable _headers = new Hashtable();

    HttpWebResponse(WebConversation client, String target, URL url, URLConnection connection, boolean throwExceptionOnError) throws IOException {
        super(client, target, url);
        this.readHeaders(connection);
        if (this._responseCode < 400 || !throwExceptionOnError) {
            this.defineRawInputStream(new BufferedInputStream(this.getInputStream(connection)));
            if (this.getContentType().startsWith("text")) {
                this.loadResponseText();
            }
        }
    }

    private InputStream getInputStream(URLConnection connection) throws IOException {
        return this.isResponseOnErrorStream(connection) ? ((HttpURLConnection)connection).getErrorStream() : connection.getInputStream();
    }

    private boolean isResponseOnErrorStream(URLConnection connection) {
        return this._responseCode >= 400 && ((HttpURLConnection)connection).getErrorStream() != null;
    }

    public int getResponseCode() {
        return this._responseCode;
    }

    public String getResponseMessage() {
        return this._responseMessage;
    }

    public String[] getHeaderFieldNames() {
        Vector names = new Vector();
        Enumeration e = this._headers.keys();
        while (e.hasMoreElements()) {
            names.addElement(e.nextElement());
        }
        Object[] result = new String[names.size()];
        names.copyInto(result);
        return result;
    }

    public String getHeaderField(String fieldName) {
        String[] fields = (String[])this._headers.get(fieldName.toUpperCase());
        return fields == null ? null : fields[0];
    }

    public String[] getHeaderFields(String fieldName) {
        String[] fields = (String[])this._headers.get(fieldName.toUpperCase());
        return fields == null ? new String[]{} : fields;
    }

    public String toString() {
        return "HttpWebResponse [url=" + this.getURL() + "; headers=" + this._headers + "]";
    }

    private void readResponseHeader(HttpURLConnection connection) throws IOException {
        if (!this.needStatusWorkaround()) {
            this._responseCode = connection.getResponseCode();
            this._responseMessage = connection.getResponseMessage();
        } else {
            if (connection.getHeaderField(0) == null) {
                throw new UnknownHostException(connection.getURL().toExternalForm());
            }
            StringTokenizer st = new StringTokenizer(connection.getHeaderField(0));
            st.nextToken();
            if (!st.hasMoreTokens()) {
                this._responseCode = 200;
                this._responseMessage = "OK";
            } else {
                try {
                    this._responseCode = Integer.parseInt(st.nextToken());
                    this._responseMessage = this.getRemainingTokens(st);
                }
                catch (NumberFormatException e) {
                    this._responseCode = 500;
                    this._responseMessage = "Cannot parse response header";
                }
            }
        }
    }

    private boolean needStatusWorkaround() {
        String jdkVersion = System.getProperty("java.version");
        return jdkVersion.startsWith("1.2") || jdkVersion.startsWith("1.3");
    }

    private String getRemainingTokens(StringTokenizer st) {
        StringBuffer messageBuffer = new StringBuffer(st.hasMoreTokens() ? st.nextToken() : "");
        while (st.hasMoreTokens()) {
            messageBuffer.append(' ').append(st.nextToken());
        }
        return messageBuffer.toString();
    }

    private void readHeaders(URLConnection connection) throws IOException {
        this.loadHeaders(connection);
        if (connection instanceof HttpURLConnection) {
            this.readResponseHeader((HttpURLConnection)connection);
        } else {
            this._responseCode = 200;
            this._responseMessage = "OK";
            if (connection.getContentType().startsWith("text")) {
                this.setContentTypeHeader(connection.getContentType() + "; charset=" + FILE_ENCODING);
            }
        }
    }

    private void loadHeaders(URLConnection connection) {
        String key;
        if (HttpUnitOptions.isLoggingHttpHeaders()) {
            System.out.println("Header:: " + connection.getHeaderField(0));
        }
        int i = 1;
        while ((key = connection.getHeaderFieldKey(i)) != null) {
            if (HttpUnitOptions.isLoggingHttpHeaders()) {
                System.out.println("Header:: " + connection.getHeaderFieldKey(i) + ": " + connection.getHeaderField(i));
            }
            this.addHeader(connection.getHeaderFieldKey(i).toUpperCase(), connection.getHeaderField(i));
            ++i;
        }
        if (connection.getContentType() != null) {
            this.setContentTypeHeader(connection.getContentType());
        }
    }

    private void addHeader(String key, String field) {
        this._headers.put(key, HttpUnitUtils.withNewValue((String[])this._headers.get(key), field));
    }
}

