/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.mavenplugins.sourceforge;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.mavenplugins.sourceforge.WebBrowser;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.MultipartPostMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Pointer;
import org.w3c.dom.Document;

public class FileReleaseSystemBean {
    private WebBrowser _browser = new WebBrowser();
    private List _files;
    private int _sfGroupId;
    private String _sfUserName;
    private String _sfPassword;
    private String _package;
    private String _release;
    private File _changeLogFile;
    private File _releaseNotesFile;
    private String _proxyHost;
    private int _proxyPort;
    private String _proxyUserName;
    private String _proxyPassword;
    private String _proxyNTDomain;
    private boolean _submitNewsItem;
    private String _packageDescription;

    public List getFiles() {
        return this._files;
    }

    public void setFiles(List files) {
        this._files = files;
    }

    public void setFilesIterator(Iterator iterator) {
        this._files = new ArrayList();
        while (iterator.hasNext()) {
            this._files.add(iterator.next());
        }
    }

    public int getSfGroupId() {
        return this._sfGroupId;
    }

    public void setSfGroupId(int sfGroupId) {
        this._sfGroupId = sfGroupId;
    }

    public String getSfUserName() {
        return this._sfUserName;
    }

    public void setSfUserName(String sfUserName) {
        this._sfUserName = sfUserName;
    }

    public String getSfPassword() {
        return this._sfPassword;
    }

    public void setSfPassword(String sfPassword) {
        this._sfPassword = sfPassword;
    }

    public String getPackage() {
        return this._package;
    }

    public void setPackage(String package1) {
        this._package = package1;
    }

    public String getRelease() {
        return this._release;
    }

    public void setRelease(String release) {
        this._release = release;
    }

    public File getChangeLogFile() {
        return this._changeLogFile;
    }

    public void setChangeLogFile(File changeLogFile) {
        this._changeLogFile = changeLogFile;
    }

    public File getReleaseNotesFile() {
        return this._releaseNotesFile;
    }

    public void setReleaseNotesFile(File releaseNotesFile) {
        this._releaseNotesFile = releaseNotesFile;
    }

    public boolean isSubmitNewsItem() {
        return this._submitNewsItem;
    }

    public void setSubmitNewsItem(boolean submitNewsItem) {
        this._submitNewsItem = submitNewsItem;
    }

    public String getPackageDescription() {
        return this._packageDescription;
    }

    public void setPackageDescription(String packageDescription) {
        this._packageDescription = packageDescription;
    }

    public String getProxyHost() {
        return this._proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this._proxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this._proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this._proxyPort = proxyPort;
    }

    public String getProxyUserName() {
        return this._proxyUserName;
    }

    public void setProxyUserName(String proxyUserName) {
        this._proxyUserName = proxyUserName;
    }

    public String getProxyPassword() {
        return this._proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this._proxyPassword = proxyPassword;
    }

    public String getProxyNTDomain() {
        return this._proxyNTDomain;
    }

    public void setProxyNTDomain(String proxyNTDomain) {
        this._proxyNTDomain = proxyNTDomain;
    }

    public void execute() throws Exception {
        try {
            int releaseId;
            if (this._sfGroupId <= 0) {
                throw new Exception("Invalid sfGroupId parameter");
            }
            if (this._package == null || this._package.trim().length() == 0) {
                throw new Exception("Invalid package parameter");
            }
            if (this._release == null || this._release.trim().length() == 0) {
                throw new Exception("Invalid release parameter");
            }
            if (this._proxyHost != null && this._proxyHost.trim().length() != 0) {
                this._browser.useProxy(this._proxyHost, this._proxyPort, this._proxyUserName, this._proxyPassword, this._proxyNTDomain);
            }
            this.login();
            GetMethod getMethod = new GetMethod("https://sourceforge.net/project/admin/editpackages.php?group_id=" + this._sfGroupId);
            Document doc = this._browser.getDocument((HttpMethod)getMethod);
            int packageId = this.getPackageId(doc);
            if (packageId == -1) {
                packageId = this.createPackage();
            }
            if ((releaseId = this.getReleaseId(doc = this._browser.getDocument((HttpMethod)(getMethod = new GetMethod("http://sourceforge.net/project/admin/editreleases.php?package_id=" + packageId + "&group_id=" + this._sfGroupId))))) == -1) {
                releaseId = this.createRelease(packageId);
            }
            if (releaseId == -1) {
                throw new Exception("Could not create release " + this._release + " for package " + this._package);
            }
            doc = this.uploadNotes(packageId, releaseId);
            doc = this.selectUploadedFiles(packageId, releaseId);
            Iterator i = this._files.iterator();
            while (i.hasNext()) {
                File file = (File)i.next();
                String fileName = file.getName();
                System.out.println("Defining file information for file " + fileName);
                int fileId = this.getFileId(doc, fileName);
                doc = this.defineFileInformation(packageId, releaseId, fileId, fileName);
            }
            this.sendEmailConfirmation(packageId, releaseId);
            if (this._submitNewsItem) {
                this.submitNewsItem();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    protected void login() throws Exception {
        GetMethod getMethod = new GetMethod("https://sourceforge.net/account/login.php");
        Document doc = this._browser.getDocument((HttpMethod)getMethod);
        PostMethod postMethod = new PostMethod("https://sourceforge.net/account/login.php");
        postMethod.setFollowRedirects(false);
        postMethod.addParameter("return_to", "/project/admin/?group_id=" + this._sfGroupId);
        postMethod.addParameter("form_loginname", this._sfUserName);
        postMethod.addParameter("form_pw", this._sfPassword);
        postMethod.addParameter("stay_in_ssl", "1");
        postMethod.addParameter("login", "Login With SSL");
        doc = this._browser.getDocument((HttpMethod)postMethod);
        if (!this.checkLoginResponse(doc)) {
            throw new Exception("Could not login in Sourgeforge website with user name " + this._sfUserName + " and password " + this._sfPassword);
        }
    }

    protected boolean checkLoginResponse(Document doc) {
        try {
            JXPathContext context = JXPathContext.newContext((Object)doc);
            context.setLenient(true);
            Object erreurs = context.getValue("//FONT[text()='Invalid Password or User Name']");
            return erreurs == null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    protected int getPackageId(Document doc) {
        JXPathContext context = JXPathContext.newContext((Object)doc);
        context.setLenient(true);
        Iterator i = context.iteratePointers("//TABLE/FORM[@action='/project/admin/editpackages.php']");
        while (i.hasNext()) {
            Pointer pointer = (Pointer)i.next();
            JXPathContext nodeContext = context.getRelativeContext(pointer);
            if (nodeContext.getValue(".//INPUT[@name='package_name'][@value='" + this._package + "']") == null) continue;
            String packageId = (String)nodeContext.getValue(".//INPUT[@name='package_id']/@value");
            return Integer.parseInt(packageId);
        }
        return -1;
    }

    protected int createPackage() throws Exception {
        System.out.println("Creating package " + this._package);
        PostMethod postMethod = new PostMethod("https://sourceforge.net/project/admin/editpackages.php");
        postMethod.setFollowRedirects(true);
        postMethod.addParameter("group_id", String.valueOf(this._sfGroupId));
        postMethod.addParameter("func", "add_package");
        postMethod.addParameter("package_name", this._package);
        Document doc = this._browser.getDocument((HttpMethod)postMethod);
        return this.getPackageId(doc);
    }

    protected int getReleaseId(Document doc) {
        JXPathContext context = JXPathContext.newContext((Object)doc);
        context.setLenient(true);
        Iterator i = context.iteratePointers("//TABLE/TR/TD[1]/FONT[starts-with(A/@href, 'editreleases.php?')]");
        while (i.hasNext()) {
            Pointer pointer = (Pointer)i.next();
            JXPathContext nodeContext = context.getRelativeContext(pointer);
            String textValue = (String)nodeContext.getValue("text()");
            if (textValue == null || !this._release.equals(textValue = textValue.trim())) continue;
            String href = (String)nodeContext.getValue("A/@href");
            int pos = href.indexOf("release_id=") + "release_id=".length();
            String releaseId = href.substring(pos);
            pos = releaseId.indexOf(38);
            releaseId = releaseId.substring(0, pos);
            return Integer.parseInt(releaseId);
        }
        return -1;
    }

    protected int createRelease(int packageId) throws Exception {
        System.out.println("Creating release " + this._release + " for package " + this._package);
        GetMethod getMethod = new GetMethod("http://sourceforge.net/project/admin/newrelease.php?packageId=" + packageId + "&group_id=" + this._sfGroupId);
        Document doc = this._browser.getDocument((HttpMethod)getMethod);
        PostMethod postMethod = new PostMethod("http://sourceforge.net/project/admin/newrelease.php");
        postMethod.addParameter("group_id", String.valueOf(this._sfGroupId));
        postMethod.addParameter("release_name", this._release);
        postMethod.addParameter("package_id", String.valueOf(packageId));
        postMethod.addParameter("submit", "Create This Release");
        doc = this._browser.getDocument((HttpMethod)postMethod);
        return this.getCreatedReleaseId(doc);
    }

    protected int getCreatedReleaseId(Document doc) throws NumberFormatException {
        JXPathContext context = JXPathContext.newContext((Object)doc);
        context.setLenient(false);
        String releaseId = (String)context.getValue("//INPUT[@name='release_id']/@value");
        return Integer.parseInt(releaseId);
    }

    protected Document uploadNotes(int packageId, int releaseId) throws Exception {
        MultipartPostMethod postMethod = new MultipartPostMethod("https://sourceforge.net/project/admin/editreleases.php");
        postMethod.addParameter("group_id", String.valueOf(this._sfGroupId));
        postMethod.addParameter("package_id", String.valueOf(packageId));
        postMethod.addParameter("new_package_id", String.valueOf(packageId));
        postMethod.addParameter("release_id", String.valueOf(releaseId));
        postMethod.addParameter("step1", "1");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        postMethod.addParameter("release_date", df.format(new Date()));
        postMethod.addParameter("release_name", this._release);
        postMethod.addParameter("status_id", "1");
        if (this._releaseNotesFile != null && this._releaseNotesFile.exists()) {
            postMethod.addParameter("uploaded_notes", this._releaseNotesFile);
        }
        if (this._changeLogFile != null && this._changeLogFile.exists()) {
            postMethod.addParameter("uploaded_changes", this._changeLogFile);
        }
        postMethod.addParameter("preformatted", "1");
        Document doc = this._browser.getDocument((HttpMethod)postMethod);
        return doc;
    }

    protected Document selectUploadedFiles(int packageId, int releaseId) throws Exception {
        PostMethod postMethod = new PostMethod("https://sourceforge.net/project/admin/editreleases.php");
        postMethod.addParameter("group_id", String.valueOf(this._sfGroupId));
        postMethod.addParameter("package_id", String.valueOf(packageId));
        postMethod.addParameter("release_id", String.valueOf(releaseId));
        postMethod.addParameter("step2", "1");
        Iterator i = this._files.iterator();
        while (i.hasNext()) {
            File file = (File)i.next();
            String fileName = file.getName();
            postMethod.addParameter("file_list[]", fileName);
        }
        Document doc = this._browser.getDocument((HttpMethod)postMethod);
        return doc;
    }

    protected int getFileId(Document doc, String fileName) throws Exception {
        JXPathContext context = JXPathContext.newContext((Object)doc);
        context.setLenient(false);
        try {
            Pointer pointer = context.getPointer("//TABLE/FORM[INPUT/@name = 'step3'][.//FONT/text() = '" + fileName + "']");
            JXPathContext nodeContext = context.getRelativeContext(pointer);
            String fileId = (String)nodeContext.getValue("INPUT[@name = 'file_id']/@value");
            return Integer.parseInt(fileId);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new Exception("Cannot locate the file " + fileName + " on the file release page");
        }
    }

    protected Document defineFileInformation(int packageId, int releaseId, int fileId, String fileName) throws Exception {
        PostMethod postMethod = new PostMethod("https://sourceforge.net/project/admin/editreleases.php");
        postMethod.addParameter("group_id", String.valueOf(this._sfGroupId));
        postMethod.addParameter("package_id", String.valueOf(packageId));
        postMethod.addParameter("release_id", String.valueOf(releaseId));
        postMethod.addParameter("new_release_id", String.valueOf(releaseId));
        postMethod.addParameter("file_id", String.valueOf(fileId));
        postMethod.addParameter("step3", "1");
        postMethod.addParameter("processor_id", "8500");
        String type = "3002";
        if (fileName.endsWith("-src.tar.gz")) {
            type = "5002";
        } else if (fileName.endsWith("-src.zip")) {
            type = "5000";
        } else if (fileName.endsWith(".gz")) {
            type = "3002";
        } else if (fileName.endsWith(".zip")) {
            type = "3000";
        }
        postMethod.addParameter("type_id", type);
        postMethod.addParameter("file_id", String.valueOf(fileId));
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        postMethod.addParameter("release_time", df.format(new Date()));
        postMethod.addParameter("submit", "Update/Refresh");
        return this._browser.getDocument((HttpMethod)postMethod);
    }

    protected void sendEmailConfirmation(int packageId, int releaseId) throws URIException {
        System.out.println("Sending confirmation email");
        PostMethod postMethod = new PostMethod("https://sourceforge.net/project/admin/editreleases.php");
        postMethod.addParameter("group_id", String.valueOf(this._sfGroupId));
        postMethod.addParameter("package_id", String.valueOf(packageId));
        postMethod.addParameter("release_id", String.valueOf(releaseId));
        postMethod.addParameter("step4", "1");
        postMethod.addParameter("sure", "1");
        postMethod.addParameter("submit", "Send Notice");
        this._browser.executeMethod((HttpMethod)postMethod);
    }

    protected void submitNewsItem() throws Exception {
        if (this._releaseNotesFile == null || !this._releaseNotesFile.exists()) {
            System.out.println("Cannot find the release notes to include in the news item.");
            return;
        }
        System.out.println("Posting news about the release");
        FileReader reader = new FileReader(this._releaseNotesFile);
        LineNumberReader lr = new LineNumberReader(new BufferedReader(reader));
        String releaseNotes = "";
        String line = lr.readLine();
        while (line != null) {
            releaseNotes = releaseNotes + line + "\n\r";
            line = lr.readLine();
        }
        GetMethod getMethod = new GetMethod("https://sourceforge.net/news/submit.php?group_id=" + this._sfGroupId);
        Document doc = this._browser.getDocument((HttpMethod)getMethod);
        PostMethod postMethod = new PostMethod("https://sourceforge.net/news/submit.php");
        postMethod.setFollowRedirects(false);
        postMethod.addParameter("group_id", String.valueOf(this._sfGroupId));
        postMethod.addParameter("post_changes", "y");
        postMethod.addParameter("summary", this._packageDescription + " " + this._release + " released.");
        postMethod.addParameter("details", releaseNotes);
        postMethod.addParameter("SUBMIT", "SUBMIT");
        this._browser.executeMethod((HttpMethod)postMethod);
    }
}

