/*
 * Decompiled with CFR 0.152.
 */
package kr.pe.kwonnam.underscore.stringbuilder.transformers.trim;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Trim {
    private Logger log = LoggerFactory.getLogger(Trim.class);
    private String prefix;
    private List<String> prefixOverrides;
    private String suffix;
    private List<String> suffixOverrides;

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public List<String> getPrefixOverrides() {
        return this.prefixOverrides;
    }

    public void setPrefixOverrides(List<String> prefixOverrides) {
        this.prefixOverrides = prefixOverrides;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public List<String> getSuffixOverrides() {
        return this.suffixOverrides;
    }

    public void setSuffixOverrides(List<String> suffixOverrides) {
        this.suffixOverrides = suffixOverrides;
    }

    public String trim(String str) {
        this.log.debug("Processing trim prefix : {}, prefixOverrides : {}, suffix : {}, suffixOverrides : {}, str : {}", new Object[]{this.prefix, this.prefixOverrides, this.suffix, this.suffixOverrides, str});
        if (str == null) {
            return null;
        }
        String trimmed = str.trim();
        if (trimmed.isEmpty()) {
            return trimmed;
        }
        trimmed = this.processPrefixOverride(trimmed);
        trimmed = this.processSuffixOverride(trimmed);
        trimmed = this.processPrefix(trimmed);
        trimmed = this.processSuffix(trimmed);
        return trimmed;
    }

    private String processPrefixOverride(String trimmed) {
        if (this.prefixOverrides == null || this.prefixOverrides.isEmpty()) {
            return trimmed;
        }
        for (String prefixOverride : this.prefixOverrides) {
            if (!trimmed.startsWith(prefixOverride)) continue;
            return trimmed.substring(prefixOverride.length());
        }
        return trimmed;
    }

    private String processSuffixOverride(String trimmed) {
        if (this.suffixOverrides == null || this.suffixOverrides.isEmpty()) {
            return trimmed;
        }
        for (String suffixOverride : this.suffixOverrides) {
            if (!trimmed.endsWith(suffixOverride)) continue;
            int idx = trimmed.lastIndexOf(suffixOverride);
            return trimmed.substring(0, idx);
        }
        return trimmed;
    }

    private String processPrefix(String trimmed) {
        if (this.prefix == null) {
            return trimmed;
        }
        return this.prefix + trimmed;
    }

    private String processSuffix(String trimmed) {
        if (this.suffix == null) {
            return trimmed;
        }
        return trimmed + this.suffix;
    }
}

