/*
 * Decompiled with CFR 0.152.
 */
package kr.pe.kwonnam.underscore.stringbuilder;

import java.io.IOException;
import kr.pe.kwonnam.underscore.stringbuilder.UnderscorePredicate;
import kr.pe.kwonnam.underscore.stringbuilder.UnderscoreSubBuild;
import kr.pe.kwonnam.underscore.stringbuilder.UnderscoreTransformer;

public final class UnderscoreStringBuilder
implements CharSequence,
Appendable {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private StringBuilder stringBuilder;
    private String prefix;
    private String suffix;

    public UnderscoreStringBuilder() {
        this(new StringBuilder());
    }

    public UnderscoreStringBuilder(StringBuilder stringBuilder) {
        if (stringBuilder == null) {
            throw new NullPointerException("stringBuilder must not be null.");
        }
        this.stringBuilder = stringBuilder;
    }

    public <A> UnderscoreStringBuilder __(A appendee) {
        return this.__(true, appendee);
    }

    public <A> UnderscoreStringBuilder __(boolean appendable, A appendee) {
        return this.__(appendable, appendee, null, (UnderscoreTransformer[])null);
    }

    public <A> UnderscoreStringBuilder __(A appendee, UnderscoreTransformer<A> transformer, UnderscoreTransformer<? super CharSequence> ... extraTransformers) {
        return this.__(true, appendee, transformer, extraTransformers);
    }

    public <A> UnderscoreStringBuilder __(boolean appendable, A appendee, UnderscoreTransformer<A> transformer, UnderscoreTransformer<? super CharSequence> ... extraTransformers) {
        if (!appendable) {
            return this;
        }
        this.doPrefix();
        Object finalAppendee = this.doTransform(appendee, transformer, extraTransformers);
        this.stringBuilder.append(finalAppendee);
        this.doSuffix();
        return this;
    }

    private <A> Object doTransform(A appendee, UnderscoreTransformer<A> transformer, UnderscoreTransformer<? super CharSequence>[] extraTransformers) {
        if (transformer == null) {
            return appendee;
        }
        CharSequence transformed = transformer.transform(appendee);
        if (extraTransformers != null && extraTransformers.length > 0) {
            for (UnderscoreTransformer<? super CharSequence> extraTransformer : extraTransformers) {
                transformed = extraTransformer.transform(transformed);
            }
        }
        return transformed;
    }

    private void doPrefix() {
        if (this.prefix != null) {
            this.stringBuilder.append(this.prefix);
        }
    }

    private void doSuffix() {
        if (this.suffix != null) {
            this.stringBuilder.append(this.suffix);
        }
    }

    public <A> UnderscoreStringBuilder __(UnderscorePredicate predicate, A appendee) {
        return this.__(predicate, appendee, null, (UnderscoreTransformer[])null);
    }

    public <A> UnderscoreStringBuilder __(UnderscorePredicate predicate, A appendee, UnderscoreTransformer<A> transformer, UnderscoreTransformer<? super CharSequence> ... extraTransformers) {
        if (predicate == null) {
            throw new IllegalArgumentException("underscorePredicate must not be null.");
        }
        return this.__(predicate.evaluate(), appendee, transformer, extraTransformers);
    }

    public UnderscoreStringBuilder sub(UnderscoreSubBuild subBuild) {
        return this.sub(true, subBuild);
    }

    public UnderscoreStringBuilder sub(UnderscoreSubBuild subBuild, UnderscoreTransformer<? super UnderscoreStringBuilder> transformer, UnderscoreTransformer<? super CharSequence> ... extraTransformers) {
        return this.sub(true, subBuild, transformer, extraTransformers);
    }

    public UnderscoreStringBuilder sub(boolean appendable, UnderscoreSubBuild subBuild) {
        return this.sub(appendable, subBuild, null, (UnderscoreTransformer[])null);
    }

    public UnderscoreStringBuilder sub(boolean appendable, UnderscoreSubBuild subBuild, UnderscoreTransformer<? super UnderscoreStringBuilder> transformer, UnderscoreTransformer<? super CharSequence> ... extraTransformers) {
        if (!appendable) {
            return this;
        }
        if (subBuild == null) {
            throw new IllegalArgumentException("subBuild must not be null.");
        }
        UnderscoreStringBuilder subBuilder = new UnderscoreStringBuilder();
        subBuild.subbuild(subBuilder);
        return this.__(subBuilder, transformer, extraTransformers);
    }

    public UnderscoreStringBuilder sub(UnderscorePredicate predicate, UnderscoreSubBuild subBuild) {
        return this.sub(predicate, subBuild, null, (UnderscoreTransformer[])null);
    }

    public UnderscoreStringBuilder sub(UnderscorePredicate predicate, UnderscoreSubBuild subBuild, UnderscoreTransformer<? super UnderscoreStringBuilder> transformer, UnderscoreTransformer<? super CharSequence> ... extraTransformers) {
        if (predicate == null) {
            throw new IllegalArgumentException("underscorePredicate must not be null.");
        }
        return this.sub(predicate.evaluate(), subBuild, transformer, extraTransformers);
    }

    public UnderscoreStringBuilder prefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public UnderscoreStringBuilder prefixOff() {
        return this.prefix(null);
    }

    public UnderscoreStringBuilder prefixNewLine() {
        return this.prefix(LINE_SEPARATOR);
    }

    public UnderscoreStringBuilder suffix(String suffix) {
        this.suffix = suffix;
        return this;
    }

    public UnderscoreStringBuilder suffixOff() {
        return this.suffix(null);
    }

    public UnderscoreStringBuilder suffixNewLine() {
        return this.suffix(LINE_SEPARATOR);
    }

    @Override
    public int length() {
        return this.stringBuilder.length();
    }

    @Override
    public char charAt(int index) {
        return this.stringBuilder.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.stringBuilder.subSequence(start, end);
    }

    @Override
    public UnderscoreStringBuilder append(CharSequence csq) throws IOException {
        this.stringBuilder.append(csq);
        return this;
    }

    @Override
    public UnderscoreStringBuilder append(CharSequence csq, int start, int end) throws IOException {
        this.stringBuilder.append(csq, start, end);
        return this;
    }

    @Override
    public UnderscoreStringBuilder append(char c) throws IOException {
        this.stringBuilder.append(c);
        return this;
    }

    @Override
    public String toString() {
        return this.stringBuilder.toString();
    }
}

