/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.helper;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import kr.jm.utils.exception.JMExceptionManager;
import kr.jm.utils.helper.JMFiles;
import kr.jm.utils.helper.JMResources;
import kr.jm.utils.helper.JMRestfulResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMObjectMapper {
    private static final Logger log = LoggerFactory.getLogger(JMObjectMapper.class);
    private ObjectMapper objectMapper;
    public final TypeReference<Map<String, Object>> MAP_TYPE_REFERENCE = this.getMapOrListTypeReference();
    public final TypeReference<List<Object>> LIST_TYPE_REFERENCE = this.getMapOrListTypeReference();
    public final TypeReference<List<Map<String, Object>>> MAP_LIST_TYPE_REFERENCE = this.getMapOrListTypeReference();

    public JMObjectMapper() {
        this(new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).enable(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL));
    }

    public JMObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public <T> TypeReference<T> getMapOrListTypeReference() {
        return new TypeReference<T>(){};
    }

    public <D> String toJsonString(D dataObject) {
        try {
            return this.getObjectMapper().writeValueAsString(dataObject);
        }
        catch (Exception e) {
            return (String)JMExceptionManager.handleExceptionAndReturnNull((Logger)log, (Throwable)e, (String)"toJsonString", (Object[])new Object[]{dataObject});
        }
    }

    private ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public String toJsonString(File jsonFile) {
        return JMFiles.readString((File)jsonFile);
    }

    public File toJsonFile(String jsonString, File returnJsonFile) {
        try {
            this.getObjectMapper().writeValue(returnJsonFile, (Object)jsonString);
            return returnJsonFile;
        }
        catch (Exception e) {
            return (File)JMExceptionManager.handleExceptionAndReturnNull((Logger)log, (Throwable)e, (String)"toJsonFile", (Object[])new Object[]{jsonString});
        }
    }

    public <D> File toJsonFile(D dataObject, File returnJsonFile) {
        try {
            this.getObjectMapper().writeValue(returnJsonFile, dataObject);
            return returnJsonFile;
        }
        catch (Exception e) {
            return (File)JMExceptionManager.handleExceptionAndReturnNull((Logger)log, (Throwable)e, (String)"toJsonFile", (Object[])new Object[]{dataObject});
        }
    }

    public <T> T withBytes(byte[] bytes, TypeReference<T> typeReference) {
        try {
            return (T)this.getObjectMapper().readValue(bytes, typeReference);
        }
        catch (Exception e) {
            return (T)JMExceptionManager.handleExceptionAndReturnNull((Logger)log, (Throwable)e, (String)"withBytes", (Object[])new Object[]{new String(bytes)});
        }
    }

    public <T> T withBytes(byte[] bytes, Class<T> c) {
        try {
            return (T)this.getObjectMapper().readValue(bytes, c);
        }
        catch (Exception e) {
            return (T)JMExceptionManager.handleExceptionAndReturnNull((Logger)log, (Throwable)e, (String)"withBytes", (Object[])new Object[]{new String(bytes)});
        }
    }

    public <T> T withJsonString(String jsonString, TypeReference<T> typeReference) {
        return this.withBytes(jsonString.getBytes(), typeReference);
    }

    public Map<String, Object> toMap(String jsonObjectString) {
        return this.withJsonString(jsonObjectString, this.MAP_TYPE_REFERENCE);
    }

    public List<Object> toList(String jsonListString) {
        return this.withJsonString(jsonListString, this.LIST_TYPE_REFERENCE);
    }

    public List<Map<String, Object>> toMapList(String jsonMapListString) {
        return this.withJsonString(jsonMapListString, this.MAP_LIST_TYPE_REFERENCE);
    }

    public <T> T withJsonString(String jsonString, Class<T> c) {
        return this.withBytes(jsonString.getBytes(), c);
    }

    public <T> T withJsonFile(File jsonFile, TypeReference<T> typeReference) {
        try {
            return (T)this.getObjectMapper().readValue(jsonFile, typeReference);
        }
        catch (Exception e) {
            return (T)JMExceptionManager.handleExceptionAndReturnNull((Logger)log, (Throwable)e, (String)"withJsonFile", (Object[])new Object[]{jsonFile});
        }
    }

    public <T> T withJsonFile(File jsonFile, Class<T> c) {
        try {
            return (T)this.getObjectMapper().readValue(jsonFile, c);
        }
        catch (Exception e) {
            return (T)JMExceptionManager.handleExceptionAndReturnNull((Logger)log, (Throwable)e, (String)"withJsonFile", (Object[])new Object[]{jsonFile});
        }
    }

    public <T> T withJsonInputStream(InputStream inputStream, TypeReference<T> typeReference) {
        try {
            return (T)this.getObjectMapper().readValue(inputStream, typeReference);
        }
        catch (Exception e) {
            return (T)JMExceptionManager.handleExceptionAndReturnNull((Logger)log, (Throwable)e, (String)"withJsonInputStream", (Object[])new Object[]{inputStream});
        }
    }

    public <T> T withJsonInputStream(InputStream inputStream, Class<T> c) {
        try {
            return (T)this.getObjectMapper().readValue(inputStream, c);
        }
        catch (Exception e) {
            return (T)JMExceptionManager.handleExceptionAndReturnNull((Logger)log, (Throwable)e, (String)"withJsonInputStream", (Object[])new Object[]{inputStream});
        }
    }

    public <T> T withJsonResource(String resourceClasspath, TypeReference<T> typeReference) {
        return this.withJsonInputStream(JMResources.getResourceInputStream((String)resourceClasspath), typeReference);
    }

    public <T> T withJsonResource(String resourceClasspath, Class<T> c) {
        return this.withJsonInputStream(JMResources.getResourceInputStream((String)resourceClasspath), c);
    }

    public <T> T withRestOrClasspathOrFilePath(String resourceRestUrlOrClasspathOrFilePath, TypeReference<T> typeReference) {
        return this.withJsonString(JMRestfulResource.getStringWithRestOrClasspathOrFilePath(resourceRestUrlOrClasspathOrFilePath), typeReference);
    }

    public <T> T withRestOrFilePathOrClasspath(String resourceRestOrFilePathOrClasspath, TypeReference<T> typeReference) {
        return this.withJsonString(JMRestfulResource.getStringWithRestOrFilePathOrClasspath(resourceRestOrFilePathOrClasspath), typeReference);
    }

    public <T> T withClasspathOrFilePath(String resourceClasspathOrFilePath, TypeReference<T> typeReference) {
        return this.withJsonString(JMResources.getStringWithClasspathOrFilePath((String)resourceClasspathOrFilePath), typeReference);
    }

    public <T> T withFilePathOrClasspath(String resourceFilePathOrClasspath, TypeReference<T> typeReference) {
        return this.withJsonString(JMResources.getStringWithFilePathOrClasspath((String)resourceFilePathOrClasspath), typeReference);
    }

    public <T> Map<String, Object> transformToMap(T object) {
        return this.transform(object, this.MAP_TYPE_REFERENCE);
    }

    public <T1, T2> T2 transform(T1 object, TypeReference<T2> typeReference) {
        try {
            return (T2)this.getObjectMapper().convertValue(object, typeReference);
        }
        catch (Exception e) {
            return (T2)JMExceptionManager.handleExceptionAndReturnNull((Logger)log, (Throwable)e, (String)"transform", (Object[])new Object[]{object});
        }
    }

    public <T1, T2> T2 transform(T1 object, Class<T2> typeClass) {
        try {
            return (T2)this.getObjectMapper().convertValue(object, typeClass);
        }
        catch (Exception e) {
            return (T2)JMExceptionManager.handleExceptionAndReturnNull((Logger)log, (Throwable)e, (String)"transform", (Object[])new Object[]{object});
        }
    }

    public String toPrettyString(String jsonString) {
        return this.toPrettyJsonString(this.withJsonString(jsonString, Object.class));
    }

    public <D> String toPrettyJsonString(D object) {
        try {
            return this.getObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            return (String)JMExceptionManager.handleExceptionAndReturnNull((Logger)log, (Throwable)e, (String)"toPrettyJsonString", (Object[])new Object[]{object});
        }
    }

    public <D> void printlnJsonString(D Object2) {
        System.out.println(this.toJsonString(Object2));
    }

    public <D> void printlnPrettyJsonString(D Object2) {
        System.out.println(this.toPrettyJsonString(Object2));
    }
}

