/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.flow.publisher;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Flow;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.SubmissionPublisher;
import kr.jm.utils.flow.publisher.JMPublisherInterface;
import kr.jm.utils.flow.publisher.JMSubmissionPublisher;
import kr.jm.utils.helper.JMLog;
import kr.jm.utils.helper.JMOptional;
import kr.jm.utils.helper.JMThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkSubmissionPublisher<T>
implements JMPublisherInterface<List<T>>,
AutoCloseable {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final int DEFAULT_BULK_SIZE = 256;
    public static final long DEFAULT_FLUSH_INTERVAL_Millis = 100L;
    private SubmissionPublisher<List<T>> listSubmissionPublisher;
    protected int bulkSize;
    protected long flushIntervalMillis;
    protected List<T> dataList;
    protected long lastDataTimestamp;
    private ScheduledFuture<?> scheduledFuture;

    public BulkSubmissionPublisher() {
        this(256);
    }

    public BulkSubmissionPublisher(int bulkSize) {
        this(bulkSize, 100L);
    }

    public BulkSubmissionPublisher(int bulkSize, long flushIntervalMillis) {
        this(new JMSubmissionPublisher<List<T>>(), bulkSize, flushIntervalMillis);
    }

    public BulkSubmissionPublisher(SubmissionPublisher<List<T>> listSubmissionPublisher, int bulkSize, long flushIntervalMillis) {
        this.listSubmissionPublisher = listSubmissionPublisher;
        this.bulkSize = bulkSize;
        this.flushIntervalMillis = flushIntervalMillis;
        this.dataList = new ArrayList<T>();
        this.lastDataTimestamp = Long.MAX_VALUE;
        this.scheduledFuture = JMThread.runWithScheduleAtFixedRate((long)this.flushIntervalMillis, (long)this.flushIntervalMillis, this::checkIntervalAndFlush);
    }

    private void checkIntervalAndFlush() {
        if (this.lastDataTimestamp < System.currentTimeMillis() - this.flushIntervalMillis && this.dataList.size() > 0) {
            JMLog.debug((Logger)this.log, (String)"checkIntervalAndFlush", (Object[])new Object[]{this.lastDataTimestamp, this.flushIntervalMillis});
            this.flush();
        }
    }

    public int submit(T[] dataArray) {
        return this.submitBulk(Optional.ofNullable(dataArray).map(Arrays::asList).orElseGet(Collections::emptyList));
    }

    public int submit(List<T> itemList) {
        return JMOptional.getOptional(itemList).map(this::submitBulk).orElse(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int submitBulk(List<T> dataList) {
        List<T> list = this.dataList;
        synchronized (list) {
            if (this.dataList.size() + dataList.size() < this.bulkSize) {
                this.dataList.addAll(dataList);
                this.setLastDataTimestamp();
            } else {
                for (T data : dataList) {
                    this.submitSingle(data);
                }
            }
            return this.dataList.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int submitSingle(T item) {
        if (Objects.isNull(item)) {
            return 0;
        }
        List<T> list = this.dataList;
        synchronized (list) {
            this.dataList.add(item);
            this.setLastDataTimestamp();
            if (this.dataList.size() >= this.bulkSize) {
                this.flush();
            }
            return 1;
        }
    }

    private void setLastDataTimestamp() {
        this.lastDataTimestamp = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        JMLog.debug((Logger)this.log, (String)"flush", (Object[])new Object[]{this.dataList.size()});
        List<T> list = this.dataList;
        synchronized (list) {
            if (this.dataList.size() > 0) {
                this.listSubmissionPublisher.submit(this.dataList);
                this.dataList = new ArrayList<T>();
            }
        }
    }

    @Override
    public void close() {
        JMLog.info((Logger)this.log, (String)"close");
        this.scheduledFuture.cancel(false);
        this.listSubmissionPublisher.close();
    }

    public String toString() {
        return "BulkSubmissionPublisher(listSubmissionPublisher=" + this.listSubmissionPublisher.toString() + ", bulkSize=" + this.bulkSize + ", flushIntervalMillis=" + this.flushIntervalMillis + ", dataList=" + this.dataList + ")";
    }

    @Override
    public void subscribe(Flow.Subscriber<? super List<T>> subscriber) {
        this.listSubmissionPublisher.subscribe(subscriber);
    }
}

