/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.flow.publisher;

import java.util.concurrent.Flow;
import java.util.function.Consumer;
import kr.jm.utils.enums.OS;
import kr.jm.utils.flow.publisher.SubmissionPublisherImplementsJM;
import kr.jm.utils.helper.JMThread;

public class WaitingSubmissionPublisher<T>
extends SubmissionPublisherImplementsJM<T> {
    private long waitingMillis;
    private int maxQueue;

    public WaitingSubmissionPublisher() {
        this(0L);
    }

    public WaitingSubmissionPublisher(long waitingMillis) {
        this(waitingMillis, WaitingSubmissionPublisher.getDefaultQueueSizeLimit());
    }

    public static int getDefaultQueueSizeLimit() {
        return OS.getAvailableProcessors() * 8;
    }

    public WaitingSubmissionPublisher(long waitingMillis, int maxQueue) {
        super(JMThread.newMaxQueueThreadPool((int)1, (long)waitingMillis, (int)maxQueue), maxQueue);
        this.waitingMillis = waitingMillis;
        this.maxQueue = maxQueue;
    }

    public long getWaitingMillis() {
        return this.waitingMillis;
    }

    public int getMaxQueue() {
        return this.maxQueue;
    }

    @Override
    public WaitingSubmissionPublisher<T> subscribeWith(Flow.Subscriber<T> ... subscribers) {
        super.subscribeWith(subscribers);
        return this;
    }

    @Override
    public WaitingSubmissionPublisher<T> consumeWith(Consumer<T> ... consumers) {
        super.consumeWith(consumers);
        return this;
    }
}

