/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.flow.publisher;

import java.util.List;
import java.util.concurrent.Flow;
import kr.jm.utils.flow.publisher.BulkSubmissionPublisher;
import kr.jm.utils.flow.publisher.WaitingSubmissionPublisher;
import kr.jm.utils.flow.subscriber.JMSubscriberBuilder;
import kr.jm.utils.helper.JMLog;
import org.slf4j.Logger;

public class BulkWaitingSubmissionPublisher<T>
extends WaitingSubmissionPublisher<List<T>> {
    private BulkSubmissionPublisher<T> bulkSubmissionPublisher;

    public BulkWaitingSubmissionPublisher() {
        this(BulkWaitingSubmissionPublisher.getDefaultQueueSizeLimit());
    }

    public BulkWaitingSubmissionPublisher(BulkSubmissionPublisher<T> bulkSubmissionPublisher) {
        this(bulkSubmissionPublisher, (long)BulkWaitingSubmissionPublisher.getDefaultQueueSizeLimit());
    }

    public BulkWaitingSubmissionPublisher(long waitingMillis) {
        this(new BulkSubmissionPublisher(), waitingMillis);
    }

    public BulkWaitingSubmissionPublisher(BulkSubmissionPublisher<T> bulkSubmissionPublisher, long waitingMillis) {
        this(bulkSubmissionPublisher, waitingMillis, BulkWaitingSubmissionPublisher.getDefaultQueueSizeLimit());
    }

    public BulkWaitingSubmissionPublisher(BulkSubmissionPublisher<T> bulkSubmissionPublisher, long waitingMillis, int queueSizeLimit) {
        super(waitingMillis, queueSizeLimit);
        this.bulkSubmissionPublisher = bulkSubmissionPublisher.subscribeWith(new Flow.Subscriber[]{JMSubscriberBuilder.build(x$0 -> super.submit(x$0))});
    }

    @Override
    public int submit(T[] dataArray) {
        return this.bulkSubmissionPublisher.submit(dataArray);
    }

    @Override
    public int submit(List<T> itemList) {
        return this.bulkSubmissionPublisher.submit(itemList);
    }

    public void submitSingle(T item) {
        this.bulkSubmissionPublisher.submitSingle(item);
    }

    public BulkSubmissionPublisher<T> getBulkSubmissionPublisher() {
        return this.bulkSubmissionPublisher;
    }

    public void flush() {
        this.bulkSubmissionPublisher.flush();
    }

    @Override
    public void close() {
        JMLog.info((Logger)this.log, (String)"close");
        this.bulkSubmissionPublisher.close();
        super.close();
    }
}

