/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.flow.publisher;

import java.util.Arrays;
import java.util.concurrent.Flow;
import java.util.function.Consumer;
import kr.jm.utils.flow.subscriber.JMSubscriberBuilder;
import kr.jm.utils.helper.JMOptional;

public interface JMPublisherInterface<T>
extends Flow.Publisher<T> {
    default public <R extends Flow.Subscriber<T>> R subscribeAndReturnSubcriber(R returnSubscriber) {
        this.subscribe(returnSubscriber);
        return returnSubscriber;
    }

    default public Flow.Subscriber<T> consumeAndReturnSubscriber(Consumer<T> consumer) {
        return this.subscribeAndReturnSubcriber(JMSubscriberBuilder.build(consumer));
    }

    default public JMPublisherInterface<T> subscribeWith(Flow.Subscriber<T> ... subscribers) {
        JMOptional.getOptional((Object[])subscribers).map(Arrays::stream).ifPresent(stream -> stream.forEach(this::subscribe));
        return this;
    }

    default public JMPublisherInterface<T> consumeWith(Consumer<T> ... consumers) {
        JMOptional.getOptional((Object[])consumers).map(Arrays::stream).ifPresent(stream -> stream.map(JMSubscriberBuilder::build).forEach(this::subscribe));
        return this;
    }
}

