/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils.flow.publisher;

import java.util.List;
import java.util.concurrent.Executor;
import kr.jm.utils.flow.publisher.BulkSubmissionPublisher;
import kr.jm.utils.flow.publisher.WaitingSubmissionPublisher;
import kr.jm.utils.flow.subscriber.JMSubscriberBuilder;

public class BulkWaitingSubmissionPublisher<T>
extends WaitingSubmissionPublisher<List<T>> {
    private BulkSubmissionPublisher<T> bulkSubmissionPublisher;

    public BulkWaitingSubmissionPublisher() {
        this(BulkWaitingSubmissionPublisher.getDefaultQueueSizeLimit());
    }

    public BulkWaitingSubmissionPublisher(BulkSubmissionPublisher<T> bulkSubmissionPublisher) {
        this(bulkSubmissionPublisher, null);
    }

    public BulkWaitingSubmissionPublisher(int queueSizeLimit) {
        this(new BulkSubmissionPublisher(), queueSizeLimit);
    }

    public BulkWaitingSubmissionPublisher(BulkSubmissionPublisher<T> bulkSubmissionPublisher, int queueSizeLimit) {
        this(bulkSubmissionPublisher, null, queueSizeLimit);
    }

    public BulkWaitingSubmissionPublisher(BulkSubmissionPublisher<T> bulkSubmissionPublisher, Executor executor) {
        this(bulkSubmissionPublisher, executor, BulkWaitingSubmissionPublisher.getDefaultQueueSizeLimit());
    }

    public BulkWaitingSubmissionPublisher(BulkSubmissionPublisher<T> bulkSubmissionPublisher, Executor executor, int queueSizeLimit) {
        super(executor, queueSizeLimit);
        bulkSubmissionPublisher.subscribe(JMSubscriberBuilder.build(x$0 -> super.submit(x$0)));
        this.bulkSubmissionPublisher = bulkSubmissionPublisher;
    }

    @Override
    public int submit(T[] dataArray) {
        return this.bulkSubmissionPublisher.submit(dataArray);
    }

    @Override
    public int submit(List<T> itemList) {
        return this.bulkSubmissionPublisher.submit(itemList);
    }

    public void submitSingle(T item) {
        this.bulkSubmissionPublisher.submitSingle(item);
    }

    public BulkSubmissionPublisher<T> getBulkSubmissionPublisher() {
        return this.bulkSubmissionPublisher;
    }
}

