/*
 * Decompiled with CFR 0.152.
 */
package kr.jm.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Function;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.util.Pair;
import kr.jm.utils.AutoStringBuilder;
import kr.jm.utils.datastructure.JMMap;
import kr.jm.utils.exception.JMExceptionManager;
import kr.jm.utils.helper.JMLog;
import kr.jm.utils.helper.JMPredicate;
import kr.jm.utils.helper.JMThread;
import kr.jm.utils.stats.JMStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMProgressiveManager<T, R> {
    private static final Logger log = LoggerFactory.getLogger(JMProgressiveManager.class);
    private Collection<T> targetCollection;
    private int totalCount;
    private SimpleIntegerProperty progressiveCount;
    private SimpleIntegerProperty progressivePercent;
    private SimpleObjectProperty<T> currentTarget;
    private SimpleObjectProperty<Optional<R>> lastResult;
    private SimpleObjectProperty<Pair<T, Exception>> lastFailure;
    private Map<T, Optional<R>> resultMap;
    private Map<T, Exception> failureMap;
    private List<Consumer<JMProgressiveManager<T, R>>> completedConsumerList;
    private CompletableFuture<Void> completableFuture;
    private boolean isStopped;
    private Function<T, Optional<R>> processFunction;

    public JMProgressiveManager(Collection<T> targetCollection, Function<T, Optional<R>> processFunction) {
        this.targetCollection = targetCollection;
        this.processFunction = processFunction;
        this.totalCount = targetCollection.size();
        this.progressiveCount = new SimpleIntegerProperty();
        this.progressivePercent = new SimpleIntegerProperty();
        this.currentTarget = new SimpleObjectProperty();
        this.lastResult = new SimpleObjectProperty();
        this.lastFailure = new SimpleObjectProperty();
        this.resultMap = new HashMap<T, Optional<R>>();
        this.failureMap = new HashMap<T, Exception>();
        this.isStopped = false;
    }

    public String toString() {
        AutoStringBuilder asb = new AutoStringBuilder(", ");
        return asb.append("totalCount=" + this.totalCount).append("progressiveCount=" + this.progressiveCount).append("progressivePercent=" + this.progressivePercent).append("currentTarget=" + this.currentTarget).append("lastResult=" + this.lastResult).append("resultList=" + this.resultMap).append("isStopped=" + this.isStopped).autoToString();
    }

    public JMProgressiveManager<T, R> start() {
        JMLog.info(log, "start");
        this.completableFuture = ((CompletableFuture)JMThread.runAsync(() -> this.targetCollection.stream().filter(JMPredicate.negate(this.isStopped())).map(this::moveNextTarget).map(t -> JMMap.putGetNew(this.resultMap, t, this.process(t))).forEach(arg_0 -> this.lastResult.set(arg_0))).thenRun(this::setStopped)).thenRun(() -> Optional.ofNullable(this.completedConsumerList).ifPresent(list -> list.parallelStream().forEach(c -> c.accept(this))));
        return this;
    }

    private Optional<R> process(T t) {
        try {
            Optional<R> resultAsOpt = this.processFunction.apply(t);
            if (resultAsOpt.isPresent()) {
                return resultAsOpt;
            }
            throw new RuntimeException("Process Failure !!! - " + t);
        }
        catch (Exception e) {
            this.lastFailure.set((Object)new Pair(t, (Object)e));
            this.failureMap.put(t, e);
            return JMExceptionManager.handleExceptionAndReturnEmptyOptional(log, e, "start", t);
        }
    }

    public JMProgressiveManager<T, R> stopAsync() {
        this.setStopped();
        return this;
    }

    public JMProgressiveManager<T, R> stopSync() {
        return this.stopAsync().getAfterCompletion();
    }

    public JMProgressiveManager<T, R> getAfterCompletion() {
        try {
            this.completableFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            JMExceptionManager.handleException(log, e, "stopSync", new Object[0]);
        }
        return this;
    }

    private void setStopped() {
        this.isStopped = true;
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    public JMProgressiveManager<T, R> registerCompletedConsumer(Consumer<JMProgressiveManager<T, R>> completedConsumer) {
        Optional.ofNullable(this.completedConsumerList).orElseGet(() -> {
            this.completedConsumerList = new ArrayList<Consumer<JMProgressiveManager<T, R>>>();
            return this.completedConsumerList;
        }).add(completedConsumer);
        return this;
    }

    public Map<T, Optional<R>> getResultMapSync() {
        return new HashMap<T, Optional<R>>(this.getAfterCompletion().resultMap);
    }

    public Map<T, Exception> getFailureMapSync() {
        return new HashMap<T, Exception>(this.getAfterCompletion().failureMap);
    }

    public JMProgressiveManager<T, R> registerLastResultChangeListener(Consumer<Optional<R>> resultChangeListener) {
        return this.registerListener((ObservableValue)this.lastResult, (Consumer)resultChangeListener);
    }

    public JMProgressiveManager<T, R> registerLastFailureChangeListener(Consumer<Pair<T, Exception>> failureChangeListener) {
        return this.registerListener((ObservableValue)this.lastFailure, (Consumer)failureChangeListener);
    }

    private <P> JMProgressiveManager<T, R> registerListener(ObservableValue<P> property, Consumer<P> listener) {
        property.addListener((op, o, n) -> listener.accept(n));
        return this;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public boolean isDone() {
        return this.completableFuture.isDone();
    }

    public JMProgressiveManager<T, R> registerCountChangeListener(Consumer<Number> countChangeListener) {
        return this.registerListener((ObservableValue)this.progressiveCount, (Consumer)countChangeListener);
    }

    public int getProgressiveCount() {
        return this.progressiveCount.get();
    }

    private T moveNextTarget(T target) {
        this.progressiveCount.set(this.getProgressiveCount() + 1);
        this.progressivePercent.set(JMStats.calPercent(this.getProgressiveCount(), this.totalCount));
        this.currentTarget.set(target);
        return target;
    }

    public JMProgressiveManager<T, R> registerPercentChangeListener(Consumer<Number> percentChangeListener) {
        return this.registerListener((ObservableValue)this.progressivePercent, (Consumer)percentChangeListener);
    }

    public int getProgressivePercent() {
        return this.progressivePercent.get();
    }

    public JMProgressiveManager<T, R> registerTargetChangeListener(Consumer<T> targetChangeListener) {
        return this.registerListener((ObservableValue)this.currentTarget, (Consumer)targetChangeListener);
    }

    public T getCurrentTarget() {
        return (T)this.currentTarget.get();
    }

    public List<T> getTargetList() {
        return new ArrayList<T>(this.targetCollection);
    }

    public Function<T, Optional<R>> getProcessFunction() {
        return this.processFunction;
    }
}

